/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;

public class SearchRequestQuery
extends AbstractQuery<PsiReference> {
    private final Project myProject;
    private final SearchRequestCollector myRequests;

    public SearchRequestQuery(Project project, SearchRequestCollector requests) {
        this.myProject = project;
        this.myRequests = requests;
    }

    @Override
    protected AsyncFuture<Boolean> processResultsAsync(Processor<PsiReference> consumer) {
        return PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequestsAsync(this.myRequests, consumer);
    }

    @Override
    protected boolean processResults(Processor<PsiReference> consumer) {
        return PsiSearchHelper.SERVICE.getInstance(this.myProject).processRequests(this.myRequests, consumer);
    }

    public String toString() {
        return this.myRequests.toString();
    }
}

