/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;

public class ProjectFilesScope
extends NamedScope {
    public static final String NAME = "Project Files";

    public ProjectFilesScope() {
        super(NAME, new AbstractPackageSet("ProjectFiles"){

            @Override
            public boolean contains(VirtualFile file, NamedScopesHolder holder) {
                return this.contains(file, holder.getProject(), holder);
            }

            @Override
            public boolean contains(VirtualFile file, Project project, NamedScopesHolder holder) {
                if (file == null) {
                    return false;
                }
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
                return holder.getProject().isInitialized() && !fileIndex.isExcluded(file) && fileIndex.getContentRootForFile(file) != null;
            }
        });
    }
}

