/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class FilePatternPackageSet
extends PatternBasedPackageSet {
    @NonNls
    public static final String SCOPE_FILE = "file";
    private Pattern myModulePattern;
    private Pattern myModuleGroupPattern;
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final String myModulePatternText;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.search.scope.packageSet.FilePatternPackageSet");

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this.myPathPattern = filePattern;
        this.myModulePatternText = modulePattern;
        if (modulePattern == null || modulePattern.isEmpty()) {
            this.myModulePattern = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            this.myModuleGroupPattern = Pattern.compile(StringUtil.replace((String)FilePatternPackageSet.escapeToRegexp(modulePattern.substring(6, idx)), (String)"*", (String)".*"));
            if (idx < modulePattern.length() - 1) {
                this.myModulePattern = Pattern.compile(StringUtil.replace((String)FilePatternPackageSet.escapeToRegexp(modulePattern.substring(idx + 1)), (String)"*", (String)".*"));
            }
        } else {
            this.myModulePattern = Pattern.compile(StringUtil.replace((String)FilePatternPackageSet.escapeToRegexp(modulePattern), (String)"*", (String)".*"));
        }
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
    }

    @Override
    public boolean contains(VirtualFile file, NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, Project project, NamedScopesHolder holder) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return file != null && this.fileMatcher(file, fileIndex, holder != null ? holder.getProjectBaseDir() : project.getBaseDir()) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
    }

    private boolean fileMatcher(VirtualFile virtualFile, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        String relativePath = FilePatternPackageSet.getRelativePath(virtualFile, fileIndex, true, projectBaseDir);
        if (relativePath == null) {
            LOG.error("vFile: " + virtualFile + "; projectBaseDir: " + projectBaseDir + "; content File: " + fileIndex.getContentRootForFile(virtualFile));
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath) && !virtualFile.equals(projectBaseDir)) {
            return false;
        }
        return this.myFilePattern.matcher(relativePath).matches();
    }

    public static boolean matchesModule(Pattern moduleGroupPattern, Pattern modulePattern, VirtualFile file, ProjectFileIndex fileIndex) {
        Module module = fileIndex.getModuleForFile(file);
        if (module != null) {
            String[] groupPath;
            if (modulePattern != null && modulePattern.matcher(module.getName()).matches()) {
                return true;
            }
            if (moduleGroupPattern != null && (groupPath = ModuleManager.getInstance(module.getProject()).getModuleGroupPath(module)) != null) {
                for (String node : groupPath) {
                    if (!moduleGroupPattern.matcher(node).matches()) continue;
                    return true;
                }
            }
        }
        return modulePattern == null && moduleGroupPattern == null;
    }

    private static String escapeToRegexp(CharSequence text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '*') {
                builder.append(c);
                continue;
            }
            builder.append('\\').append(c);
        }
        return builder.toString();
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\" + separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\" + separator + "]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\" + separator + "(.*\\" + separator + ")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\" + separator + "]*");
        }
        return buf.toString();
    }

    @Override
    public PackageSet createCopy() {
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    public String getText() {
        StringBuffer buf = new StringBuffer(SCOPE_FILE);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        return buf.toString();
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual((String)this.myPathPattern, (String)oldQName) || Comparing.strEqual((String)(oldQName + "//*"), (String)this.myPathPattern) || Comparing.strEqual((String)(oldQName + "/*"), (String)this.myPathPattern);
    }

    public static String getRelativePath(VirtualFile virtualFile, ProjectFileIndex index, boolean useFQName, VirtualFile projectBaseDir) {
        VirtualFile contentRootForFile = index.getContentRootForFile(virtualFile);
        if (contentRootForFile != null) {
            return VfsUtilCore.getRelativePath(virtualFile, contentRootForFile, '/');
        }
        Module module = index.getModuleForFile(virtualFile);
        if (module != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor(projectBaseDir, virtualFile, false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath(virtualFile, projectBaseDir, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile, ProjectFileIndex index) {
        StringBuilder relativePath = new StringBuilder(100);
        for (VirtualFile directory = virtualFile; directory != null && index.isInLibraryClasses(directory); directory = directory.getParent()) {
            relativePath.insert(0, '/');
            relativePath.insert(0, directory.getName());
        }
        return relativePath.toString();
    }
}

