/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;

public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE = ServiceManager.getService(IndexPatternSearch.class);

    protected IndexPatternSearch() {
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPattern pattern) {
        SearchParameters parameters = new SearchParameters(file, pattern);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPattern pattern, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPatternProvider patternProvider) {
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static int getOccurrencesCount(PsiFile file, IndexPatternProvider patternProvider) {
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(PsiFile file, IndexPattern pattern) {
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(PsiFile var1, IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(PsiFile var1, IndexPattern var2);

    public static class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;

        public SearchParameters(PsiFile file, IndexPattern pattern) {
            this(file, pattern, null);
        }

        public SearchParameters(PsiFile file, IndexPattern pattern, TextRange range) {
            this.myFile = file;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
        }

        public SearchParameters(PsiFile file, IndexPatternProvider patternProvider) {
            this(file, patternProvider, null);
        }

        public SearchParameters(PsiFile file, IndexPatternProvider patternProvider, TextRange range) {
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }
    }
}

