/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;

public class MethodReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.methodReferencesSearch");
    public static final MethodReferencesSearch INSTANCE = new MethodReferencesSearch();

    private MethodReferencesSearch() {
    }

    public static Query<PsiReference> search(PsiMethod method, SearchScope scope, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch));
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector collector, final Processor<PsiReference> processor) {
        MethodReferencesSearch.searchOptimized(method, scope, strictSignatureSearch, collector, false, new PairProcessor<PsiReference, SearchRequestCollector>(){

            public boolean process(PsiReference psiReference, SearchRequestCollector collector) {
                return processor.process((Object)psiReference);
            }
        });
    }

    public static void searchOptimized(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector collector, boolean inReadAction, PairProcessor<PsiReference, SearchRequestCollector> processor) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        collector.searchQuery(new QuerySearchRequest(MethodReferencesSearch.search(new SearchParameters(method, scope, strictSignatureSearch, nested)), nested, inReadAction, processor));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        Query<PsiReference> result = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return MethodReferencesSearch.uniqueResults(result);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        Project project = PsiUtilCore.getProjectInReadAction(parameters.getMethod());
        return MethodReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result, new SearchRequestQuery(project, requests)));
    }

    public static Query<PsiReference> search(PsiMethod method, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(method, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(method)), strictSignatureSearch);
    }

    public static Query<PsiReference> search(PsiMethod method) {
        return MethodReferencesSearch.search(method, true);
    }

    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(Query<PsiReference> composite) {
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        private final SearchScope myScope;
        private final boolean myStrictSignatureSearch;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(PsiMethod method, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector optimizer) {
            this.myMethod = method;
            this.myScope = scope;
            this.myStrictSignatureSearch = strictSignatureSearch;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer != null ? optimizer : new SearchRequestCollector(new SearchSession());
        }

        public SearchParameters(PsiMethod method, SearchScope scope, boolean strict) {
            this(method, scope, strict, null);
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isStrictSignatureSearch() {
            return this.myStrictSignatureSearch;
        }

        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        public SearchScope getScope() {
            return this.getScopeDeterminedByUser();
        }

        public SearchScope getEffectiveSearchScope() {
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myMethod.getProject()).getUseScope(this.myMethod);
            return this.myScope.intersectWith(accessScope);
        }
    }
}

