/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;

public class ReferenceDescriptor {
    public static final Function<PsiReference, ReferenceDescriptor> MAPPER = new Function<PsiReference, ReferenceDescriptor>(){

        public ReferenceDescriptor fun(PsiReference psiReference) {
            PsiElement element = psiReference.getElement();
            PsiFile file = element.getContainingFile();
            return new ReferenceDescriptor(file, element.getTextRange().getStartOffset() + psiReference.getRangeInElement().getStartOffset());
        }
    };
    private final PsiFile file;
    private final int offset;

    private ReferenceDescriptor(PsiFile file, int offset) {
        this.file = file;
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceDescriptor)) {
            return false;
        }
        ReferenceDescriptor that = (ReferenceDescriptor)o;
        if (this.offset != that.offset) {
            return false;
        }
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return 31 * this.file.hashCode() + this.offset;
    }
}

