/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    public IStubElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    public abstract PsiT createPsi(StubT var1);

    public abstract StubT createStub(PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    public String getId(StubT stub) {
        assert (stub.getStubType() == this);
        StubElement parent = stub.getParentStub();
        int count = 0;
        for (StubElement child : parent.getChildrenStubs()) {
            if (child.getStubType() == this) {
                ++count;
            }
            if (child != stub) continue;
            return '#' + String.valueOf(count);
        }
        throw new RuntimeException("Parent/child relations corrupted");
    }
}

