/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(PsiFile file) {
        LighterAST tree = FORCED_AST.get();
        if (tree == null) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + fileType + ", " + file);
                return null;
            }
            Language language = ((LanguageFileType)fileType).getLanguage();
            IFileElementType contentType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).getFileNodeType();
            if (!(contentType instanceof IStubFileElementType)) {
                LOG.error("File is not of IStubFileElementType: " + contentType + ", " + file);
                return null;
            }
            FileASTNode node = file.getNode();
            tree = contentType instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        if (tree == null) {
            return null;
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    protected StubElement createStubForFile(PsiFile file, LighterAST tree) {
        return new PsiFileStubImpl<PsiFile>(file);
    }

    protected void buildStubTree(LighterAST tree, LighterASTNode root, StubElement rootStub) {
        Stack parents = new Stack();
        TIntStack childNumbers = new TIntStack();
        Stack kinderGarden = new Stack();
        Stack parentStubs = new Stack();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        block0: while (element != null) {
            List kids;
            StubElement stub = this.createStub(tree, element, parentStub);
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push((Object)parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push((Object)parentStub);
                }
                parent = element;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = children.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    protected StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    return lightElementType.createStub(tree, element, parentStub);
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass((Object)elementType) + ", " + element);
            }
        }
        return parentStub;
    }

    private boolean skipNode(LighterAST tree, LighterASTNode parent, LighterASTNode node) {
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(ASTNode parent, ASTNode node) {
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(LighterAST tree, LighterASTNode parent, LighterASTNode node) {
        return false;
    }
}

