/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer = new TIntObjectHashMap();
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId = new TObjectIntHashMap();
    private final RecentStringInterner myStringInterner = new RecentStringInterner();

    public StubSerializationHelper(AbstractStringEnumerator nameStorage) {
        this.myNameStorage = nameStorage;
    }

    public void assignId(ObjectStubSerializer serializer) throws IOException {
        int id = this.persistentId(serializer);
        ObjectStubSerializer old = (ObjectStubSerializer)this.myIdToSerializer.put(id, (Object)serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put((Object)serializer, id);
        assert (oldId == 0) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(ObjectStubSerializer serializer) throws IOException {
        return this.myNameStorage.enumerate((Object)serializer.getExternalId());
    }

    private void doSerialize(Stub rootStub, StubOutputStream stream) throws IOException {
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer(rootStub);
        DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)this.getClassId(serializer));
        serializer.serialize(rootStub, stream);
        List<? extends Stub> children = rootStub.getChildrenStubs();
        int childrenSize = children.size();
        DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            this.doSerialize(children.get(i), stream);
        }
    }

    public void serialize(Stub rootStub, OutputStream stream) throws IOException {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, storage);
        if (rootStub instanceof PsiFileStub) {
            PsiFileStub[] roots = ((PsiFileStub)rootStub).getStubRoots();
            DataInputOutputUtil.writeINT((DataOutput)((Object)stubOutputStream), (int)roots.length);
            for (PsiFileStub root : roots) {
                this.doSerialize(root, stubOutputStream);
            }
        } else {
            DataInputOutputUtil.writeINT((DataOutput)((Object)stubOutputStream), (int)1);
            this.doSerialize(rootStub, stubOutputStream);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        int idValue = this.mySerializerToId.get((Object)serializer);
        assert (idValue != 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer);
        return idValue;
    }

    public Stub deserialize(InputStream stream) throws IOException, SerializerNotFoundException {
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, storage);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage.myStrings.add(s);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount > 1) {
            PsiFileStub[] stubsArray;
            ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
            while (stubFilesCount-- > 0) {
                PsiFileStub fileStub = (PsiFileStub)this.deserialize(inputStream, null);
                stubs.add(fileStub);
            }
            for (PsiFileStub stub : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
                if (!(stub instanceof PsiFileStubImpl)) continue;
                ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
            }
            return stubsArray[0];
        }
        return this.deserialize(inputStream, null);
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    private Stub deserialize(StubInputStream stream, Stub parentStub) throws IOException, SerializerNotFoundException {
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        ObjectStubSerializer serializer = this.getClassById(id);
        if (serializer == null) {
            String externalId = null;
            try {
                externalId = (String)this.myNameStorage.valueOf(id);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw new SerializerNotFoundException("No serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() : "null"));
        }
        Object stub = serializer.deserialize(stream, parentStub);
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            this.deserialize(stream, (Stub)stub);
        }
        return stub;
    }

    private ObjectStubSerializer getClassById(int id) {
        return (ObjectStubSerializer)this.myIdToSerializer.get(id);
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(String value) throws IOException {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) throws IOException {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

