/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;

public class IElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.tree.IElementType");
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final Predicate TRUE = new Predicate(){

        @Override
        public boolean matches(IElementType type) {
            return true;
        }
    };
    public static final short FIRST_TOKEN_INDEX = 1;
    public static final short MAX_INDEXED_TYPES = 15000;
    private static short ourCounter = 1;
    private static IElementType[] ourRegistry = new IElementType[700];
    private static final ReentrantReadWriteLock.ReadLock ourRegistryReadLock;
    private static final ReentrantReadWriteLock.WriteLock ourRegistryWriteLock;
    private final short myIndex;
    private final String myDebugName;
    private final Language myLanguage;

    public IElementType(@NonNls String debugName, Language language) {
        this(debugName, language, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls String debugName, Language language, boolean register) {
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            ourRegistryWriteLock.lock();
            try {
                short s = ourCounter;
                ourCounter = (short)(s + 1);
                this.myIndex = s;
                LOG.assertTrue(this.myIndex < 15000, (Object)"Too many element types registered. Out of (short) range.");
                int registryIndex = this.myIndex - 1;
                if (ourRegistry.length == registryIndex) {
                    IElementType[] newRegistry = new IElementType[ourRegistry.length << 1];
                    System.arraycopy(ourRegistry, 0, newRegistry, 0, ourRegistry.length);
                    ourRegistry = newRegistry;
                }
                IElementType.ourRegistry[registryIndex] = this;
            }
            finally {
                ourRegistryWriteLock.unlock();
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IElementType find(short idx) {
        ourRegistryReadLock.lock();
        try {
            if (idx == 0) {
                IElementType iElementType = ourRegistry[0];
                return iElementType;
            }
            if (idx >= ourCounter) {
                IElementType iElementType = null;
                return iElementType;
            }
            IElementType iElementType = ourRegistry[idx - 1];
            return iElementType;
        }
        finally {
            ourRegistryReadLock.unlock();
        }
    }

    static short getAllocatedTypesCount() {
        return ourCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IElementType[] enumerate(Predicate p) {
        IElementType[] copy;
        ourRegistryReadLock.lock();
        try {
            copy = new IElementType[ourCounter - 1];
            System.arraycopy(ourRegistry, 0, copy, 0, ourCounter - 1);
        }
        finally {
            ourRegistryReadLock.unlock();
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value : copy) {
            if (!p.matches(value)) continue;
            matches.add(value);
        }
        return matches.toArray(new IElementType[matches.size()]);
    }

    static {
        ReentrantReadWriteLock ourLock = new ReentrantReadWriteLock();
        ourRegistryReadLock = ourLock.readLock();
        ourRegistryWriteLock = ourLock.writeLock();
    }

    public static interface Predicate {
        public boolean matches(IElementType var1);
    }
}

