/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    public static String extractClassName(String fqName) {
        int i = fqName.lastIndexOf(46);
        return i == -1 ? fqName : fqName.substring(i + 1);
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(PsiClass aClass, StringBuilder buf) {
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = ClassUtil.getContainerClass(aClass);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static PsiClass getContainerClass(PsiClass aClass) {
        PsiElement parent;
        for (parent = aClass.getContext(); parent != null && !(parent instanceof PsiClass); parent = parent.getContext()) {
        }
        return (PsiClass)parent;
    }

    public static int getNonQualifiedClassIdx(final PsiClass psiClass) {
        final int[] result = new int[]{-1};
        PsiClass containingClass = ClassUtil.getContainerClass(psiClass);
        if (containingClass != null) {
            containingClass.accept(new JavaRecursiveElementVisitor(){
                private int myCurrentIdx = 0;

                @Override
                public void visitElement(PsiElement element) {
                    if (result[0] == -1) {
                        super.visitElement(element);
                    }
                }

                @Override
                public void visitClass(PsiClass aClass) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (psiClass == aClass) {
                            result[0] = this.myCurrentIdx;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, PsiClass containingClass) {
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, final PsiClass containingClass, final boolean jvmCompatible) {
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = !prefix.isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx = 0;

            @Override
            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual((String)name, (String)aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual((String)name, (String)aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    private static String getDigitPrefix(String indexName) {
        char c;
        int i;
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        return i == 0 ? "" : indexName.substring(0, i);
    }

    public static PsiClass findPsiClass(PsiManager psiManager, String externalName) {
        return ClassUtil.findPsiClass(psiManager, externalName, null, false);
    }

    public static PsiClass findPsiClass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        return ClassUtil.findPsiClass(psiManager, externalName, psiClass, jvmCompatible, GlobalSearchScope.allScope(psiManager.getProject()));
    }

    public static PsiClass findPsiClass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible, GlobalSearchScope scope) {
        for (int pos = 0; pos < externalName.length(); ++pos) {
            PsiClass res;
            if (externalName.charAt(pos) != '$') continue;
            PsiClass parentClass = psiClass;
            if (parentClass == null) {
                parentClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName.substring(0, pos), scope);
            }
            if (parentClass == null || (res = ClassUtil.findSubclass(psiManager, externalName.substring(pos + 1), parentClass, jvmCompatible)) == null) continue;
            return res;
        }
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName, scope);
    }

    private static PsiClass findSubclass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        for (int pos = 0; pos < externalName.length(); ++pos) {
            if (externalName.charAt(pos) != '$') continue;
            PsiClass anonymousClass = ClassUtil.findNonQualifiedClassByIndex(externalName.substring(0, pos), psiClass, jvmCompatible);
            if (anonymousClass == null) {
                return null;
            }
            PsiClass res = ClassUtil.findPsiClass(psiManager, externalName.substring(pos), anonymousClass, jvmCompatible);
            if (res == null) continue;
            return res;
        }
        return ClassUtil.findNonQualifiedClassByIndex(externalName, psiClass, jvmCompatible);
    }

    public static String getJVMClassName(PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    public static PsiClass findPsiClassByJVMName(PsiManager manager, String jvmClassName) {
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }
}

