/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(PsiClass aClass, PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(PsiClass aClass, boolean includeSelf, Processor<PsiClass> superProcessor) {
        if (aClass == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process((Object)aClass)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass, superProcessor, (Set<PsiClass>)new THashSet());
    }

    private static boolean processSupers(PsiClass aClass, Processor<PsiClass> superProcessor, Set<PsiClass> visited) {
        if (!visited.add(aClass)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (superProcessor.process((Object)intf) && InheritanceUtil.processSupers(intf, superProcessor, visited)) continue;
            return false;
        }
        PsiClass superClass = aClass.getSuperClass();
        return superClass == null || superProcessor.process((Object)superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited);
    }

    public static boolean isInheritor(PsiType type, @NonNls String baseClassName) {
        if (type instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type).resolve(), baseClassName);
        }
        return false;
    }

    public static boolean isInheritor(PsiClass psiClass, String baseClassName) {
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    public static boolean isInheritor(PsiClass psiClass, boolean strict, String baseClassName) {
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(PsiClass aClass, Set<PsiClass> results, boolean includeNonProject) {
        InheritanceUtil.getSuperClassesOfList(aClass.getSuperTypes(), results, includeNonProject, (Set<PsiClass>)new THashSet(), aClass.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(PsiClass aClass) {
        LinkedHashSet<PsiClass> result = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass, result, true);
        return result;
    }

    private static void getSuperClassesOfList(PsiClassType[] types, Set<PsiClass> results, boolean includeNonProject, Set<PsiClass> visited, PsiManager manager) {
        for (PsiClassType type : types) {
            PsiClass resolved = type.resolve();
            if (resolved == null || !visited.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass, PsiElement scope, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        PsiElement place;
        PsiManager manager = aClass.getManager();
        for (place = scope; place != null && place != aClass && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass, true) : manager.areElementsEquivalent(place, aClass)) {
                    return true;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return true;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList.hasModifierProperty("static")) continue;
            return false;
        }
        return place == aClass;
    }
}

