/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.MethodSignatureBackedByPsiMethod");
    private final PsiMethod myMethod;
    private final boolean myIsRaw;
    private final String myName;

    protected MethodSignatureBackedByPsiMethod(PsiMethod method, PsiSubstitutor substitutor, boolean isRaw, PsiType[] parameterTypes, PsiTypeParameter[] methodTypeParameters) {
        super(substitutor, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        this.myMethod = method;
        this.myName = method.getName();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public static MethodSignatureBackedByPsiMethod create(PsiMethod method, PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create(method, substitutor, PsiUtil.isRawSubstitutor(method, substitutor));
    }

    public static MethodSignatureBackedByPsiMethod create(PsiMethod method, PsiSubstitutor substitutor, boolean isRaw) {
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        if (isRaw) {
            substitutor = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(substitutor, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        assert (substitutor.isValid());
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = PsiType.createArray(parameters.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType type = parameter.getType();
            PsiType psiType = parameterTypes[i] = isRaw ? TypeConversionUtil.erasure(substitutor.substitute(type)) : type;
            if (parameterTypes[i].isValid()) continue;
            PsiUtil.ensureValidType(parameterTypes[i], "Method " + method + " of " + method.getClass() + "; param " + parameter + " of " + parameter.getClass());
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor, isRaw, parameterTypes, methodTypeParameters);
    }
}

