/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiTreeUtil");
    private static final Key<Integer> INDEX = Key.create((String)"PsiTreeUtil.copyElements.INDEX");
    private static final Key<Object> MARKER = Key.create((String)"PsiTreeUtil.copyElements.MARKER");

    public static boolean isAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        PsiElement parent;
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element instanceof StubBasedPsiElement && ((StubBasedPsiElement)element).getStub() != null) && ancestor.getContainingFile() != element.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isContextAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        PsiElement parent;
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getContext() : element;
        while (parent != null) {
            PsiElement context;
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile && (context = parent.getContext()) == null) {
                return false;
            }
            parent = parent.getContext();
        }
        return false;
    }

    public static PsiElement findCommonParent(List<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    public static PsiElement findCommonParent(PsiElement element1, PsiElement element2) {
        PsiElement parent2;
        PsiElement parent1;
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        ArrayList<PsiElement> parents1 = PsiTreeUtil.getParents(element1, topLevel);
        ArrayList<PsiElement> parents2 = PsiTreeUtil.getParents(element2, topLevel);
        int size = Math.min(parents1.size(), parents2.size());
        PsiElement parent = topLevel;
        for (int i = 1; i <= size && (parent1 = parents1.get(parents1.size() - i)).equals(parent2 = parents2.get(parents2.size() - i)); ++i) {
            parent = parent1;
        }
        return parent;
    }

    private static ArrayList<PsiElement> getParents(PsiElement element, PsiElement topLevel) {
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        return parents;
    }

    public static PsiElement findCommonContext(PsiElement ... elements) {
        return PsiTreeUtil.findCommonContext(Arrays.asList(elements));
    }

    public static PsiElement findCommonContext(Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    public static PsiElement findCommonContext(PsiElement element1, PsiElement element2) {
        PsiElement parent2;
        PsiElement parent1;
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        ArrayList<PsiElement> parents1 = PsiTreeUtil.getContexts(element1, topLevel);
        ArrayList<PsiElement> parents2 = PsiTreeUtil.getContexts(element2, topLevel);
        int size = Math.min(parents1.size(), parents2.size());
        PsiElement parent = topLevel;
        for (int i = 1; i <= size && (parent1 = parents1.get(parents1.size() - i)).equals(parent2 = parents2.get(parents2.size() - i)); ++i) {
            parent = parent1;
        }
        return parent;
    }

    private static ArrayList<PsiElement> getContexts(PsiElement element, PsiElement topLevel) {
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getContext()) {
            parents.add(parent);
        }
        return parents;
    }

    public static <T extends PsiElement> T findChildOfType(PsiElement element, Class<T> aClass) {
        return PsiTreeUtil.findChildOfAnyType(element, true, aClass);
    }

    public static <T extends PsiElement> T findChildOfType(PsiElement element, Class<T> aClass, boolean strict) {
        return PsiTreeUtil.findChildOfAnyType(element, strict, aClass);
    }

    public static <T extends PsiElement> T findChildOfAnyType(PsiElement element, Class<? extends T> ... classes) {
        return PsiTreeUtil.findChildOfAnyType(element, true, classes);
    }

    public static <T extends PsiElement> T findChildOfAnyType(final PsiElement element, final boolean strict, final Class<? extends T> ... classes) {
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(PsiElement each) {
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return this.setFound(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        return processor.getFoundElement();
    }

    public static <T extends PsiElement> Collection<T> findChildrenOfType(PsiElement element, Class<? extends T> aClass) {
        return PsiTreeUtil.findChildrenOfAnyType(element, aClass);
    }

    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(final PsiElement element, final Class<? extends T> ... classes) {
        if (element == null) {
            return ContainerUtil.emptyList();
        }
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements<T>(){

            @Override
            public boolean execute(T each) {
                if (each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes)) {
                    return super.execute(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        return processor.getCollection();
    }

    public static <T extends PsiElement> T getChildOfType(PsiElement element, Class<T> aClass) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public static PsiElement findFirstParent(PsiElement element, Condition<PsiElement> condition) {
        return PsiTreeUtil.findFirstParent(element, false, condition);
    }

    public static PsiElement findFirstParent(PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (condition.value((Object)element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static <T extends PsiElement> T getRequiredChildOfType(PsiElement element, Class<T> aClass) {
        T child = PsiTreeUtil.getChildOfType(element, aClass);
        assert (child != null) : "Missing required child of type " + aClass.getName();
        return child;
    }

    public static <T extends PsiElement> T[] getChildrenOfType(PsiElement element, Class<T> aClass) {
        if (element == null) {
            return null;
        }
        List result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(child);
        }
        return result == null ? null : (PsiElement[])ArrayUtil.toObjectArray(result, aClass);
    }

    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(PsiElement element, Class<T> aClass) {
        if (element == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        return result;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes) {
        if (classes != null) {
            for (Class<?> c : classes) {
                if (!c.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends PsiElement> T getChildOfAnyType(PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(child)) continue;
                return (T)child;
            }
        }
        return null;
    }

    public static <T extends PsiElement> T getNextSiblingOfType(PsiElement sibling, Class<T> aClass) {
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public static <T extends PsiElement> T getPrevSiblingOfType(PsiElement sibling, Class<T> aClass) {
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public static <T extends PsiElement> T getTopmostParentOfType(PsiElement element, Class<T> aClass) {
        T next;
        T answer = PsiTreeUtil.getParentOfType(element, aClass);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass)) != null) {
            answer = next;
        }
        return answer;
    }

    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<T> aClass) {
        return PsiTreeUtil.getParentOfType(element, aClass, true);
    }

    public static PsiElement getStubOrPsiParent(PsiElement element) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            StubElement parentStub = stub.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element != null ? element.getParent() : null;
    }

    public static <E extends PsiElement> E getStubOrPsiParentOfType(PsiElement element, Class<E> parentClass) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    public static <T extends PsiElement> T getContextOfType(PsiElement element, Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !aClass.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            element = element.getContext();
        }
        return (T)element;
    }

    public static <T extends PsiElement> T getContextOfType(PsiElement element, Class<? extends T> aClass, boolean strict) {
        return PsiTreeUtil.getContextOfType(element, strict, aClass);
    }

    public static <T extends PsiElement> T getContextOfType(PsiElement element, Class<? extends T> ... classes) {
        return PsiTreeUtil.getContextOfType(element, true, classes);
    }

    public static <T extends PsiElement> T getContextOfType(PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(element, classes)) {
            element = element.getContext();
        }
        return (T)element;
    }

    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<T> aClass, boolean strict) {
        return PsiTreeUtil.getParentOfType(element, aClass, strict, -1);
    }

    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<T> aClass, boolean strict, int minStartOffset) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && (minStartOffset == -1 || element.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass.isInstance(element)) {
                return (T)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !aClass.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    public static PsiElement skipSiblingsForward(PsiElement element, Class ... elementClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement skipSiblingsBackward(PsiElement element, Class ... elementClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement skipParentsOfType(PsiElement element, Class ... parentClasses) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            if (PsiTreeUtil.instanceOf(e, parentClasses)) continue;
            return e;
        }
        return null;
    }

    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent, classes);
    }

    public static <T extends PsiElement> T getNonStrictParentOfType(PsiElement element, Class<? extends T> ... classes) {
        for (PsiElement run = element; run != null; run = run.getParent()) {
            if (PsiTreeUtil.instanceOf(run, classes)) {
                return (T)run;
            }
            if (run instanceof PsiFile) break;
        }
        return null;
    }

    public static PsiElement[] collectElements(PsiElement element, PsiElementFilter filter) {
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(filter);
        PsiTreeUtil.processElements(element, processor);
        return processor.toArray();
    }

    public static <T extends PsiElement> Collection<T> collectElementsOfType(PsiElement element, final Class<T> ... classes) {
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(new PsiElementFilter(){

            @Override
            public boolean isAccepted(PsiElement element) {
                for (Class clazz : classes) {
                    if (!clazz.isInstance(element)) continue;
                    return true;
                }
                return false;
            }
        });
        PsiTreeUtil.processElements(element, processor);
        return processor.getCollection();
    }

    public static boolean processElements(PsiElement element, final PsiElementProcessor processor) {
        if (element == null) {
            return true;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!processor.execute(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result = new boolean[]{true};
        element.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (processor.execute(element)) {
                    super.visitElement(element);
                } else {
                    this.stopWalking();
                    result[0] = false;
                }
            }
        });
        return result[0];
    }

    public static boolean processElements(PsiElementProcessor processor, PsiElement ... elements) {
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PsiTreeUtil.processElements(element, processor)) continue;
            return false;
        }
        return true;
    }

    public static PsiElement[] copyElements(PsiElement[] elements) {
        int i;
        ArrayList<PsiElement> roots = new ArrayList<PsiElement>();
        for (i = 0; i < elements.length; ++i) {
            PsiElement rootCandidate = elements[i];
            boolean failed = false;
            for (int j = 0; j < elements.length; ++j) {
                PsiElement element = elements[j];
                if (i == j || !PsiTreeUtil.isAncestor(element, rootCandidate, true)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            roots.add(rootCandidate);
        }
        for (i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            element.putCopyableUserData(INDEX, i);
        }
        PsiElement[] newRoots = new PsiElement[roots.size()];
        for (int i2 = 0; i2 < roots.size(); ++i2) {
            PsiElement root = (PsiElement)roots.get(i2);
            newRoots[i2] = root.copy();
        }
        PsiElement[] result = new PsiElement[elements.length];
        for (PsiElement newRoot : newRoots) {
            PsiTreeUtil.decodeIndices(newRoot, result);
        }
        return result;
    }

    private static void decodeIndices(PsiElement element, PsiElement[] result) {
        Integer data = element.getCopyableUserData(INDEX);
        if (data != null) {
            element.putCopyableUserData(INDEX, null);
            int index = data;
            result[index] = element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiTreeUtil.decodeIndices(child, result);
        }
    }

    public static void mark(PsiElement element, Object marker) {
        element.putCopyableUserData(MARKER, marker);
    }

    public static PsiElement releaseMark(PsiElement root, Object marker) {
        if (marker.equals(root.getCopyableUserData(MARKER))) {
            root.putCopyableUserData(MARKER, null);
            return root;
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result = PsiTreeUtil.releaseMark(child, marker);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <T extends PsiElement> T findElementOfClassAtOffset(PsiFile file, int offset, Class<T> clazz, boolean strictStart) {
        List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
        PsiElement result = null;
        for (PsiFile root : psiRoots) {
            T parent;
            PsiElement elementAt = root.findElementAt(offset);
            if (elementAt == null || (parent = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart)) == null) continue;
            TextRange range = parent.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result != null && result.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result = parent;
        }
        return (T)result;
    }

    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(PsiFile file, int offset, Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
        PsiElement result = null;
        for (PsiFile root : psiRoots) {
            T parent;
            PsiElement elementAt = root.findElementAt(offset);
            if (elementAt == null || (parent = PsiTreeUtil.getParentOfType(elementAt, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result != null && result.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result = parent;
        }
        return (T)result;
    }

    public static <T extends PsiElement> T findElementOfClassAtRange(PsiFile file, int startOffset, int endOffset, Class<T> clazz) {
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement result = null;
        for (Language lang : viewProvider.getLanguages()) {
            T run;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            T prev = run = PsiTreeUtil.getParentOfType(elementAt, clazz, false);
            while (run != null && run.getTextRange().getStartOffset() == startOffset && run.getTextRange().getEndOffset() <= endOffset) {
                prev = run;
                run = PsiTreeUtil.getParentOfType(run, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result != null && result.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result = prev;
        }
        return (T)result;
    }

    public static PsiElement getDeepestFirst(PsiElement elt) {
        PsiElement res = elt;
        PsiElement firstChild;
        while ((firstChild = res.getFirstChild()) != null) {
            res = firstChild;
        }
        return res;
    }

    public static PsiElement getDeepestLast(PsiElement elt) {
        PsiElement res = elt;
        PsiElement lastChild;
        while ((lastChild = res.getLastChild()) != null) {
            res = lastChild;
        }
        return res;
    }

    public static PsiElement prevLeaf(PsiElement current) {
        PsiElement prevSibling = current.getPrevSibling();
        if (prevSibling != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent);
    }

    public static PsiElement nextLeaf(PsiElement current) {
        PsiElement nextSibling = current.getNextSibling();
        if (nextSibling != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent);
    }

    public static PsiElement lastChild(PsiElement element) {
        PsiElement lastChild = element.getLastChild();
        if (lastChild != null) {
            return PsiTreeUtil.lastChild(lastChild);
        }
        return element;
    }

    public static PsiElement firstChild(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child != null) {
            return PsiTreeUtil.firstChild(child);
        }
        return element;
    }

    public static PsiElement prevLeaf(PsiElement element, boolean skipEmptyElements) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    public static PsiElement prevVisibleLeaf(PsiElement element) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces((String)prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    public static PsiElement nextVisibleLeaf(PsiElement element) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces((String)nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    public static PsiElement nextLeaf(PsiElement element, boolean skipEmptyElements) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(PsiElement element) {
        if (element instanceof PsiErrorElement) {
            return true;
        }
        for (PsiElement child : element.getChildren()) {
            if (!PsiTreeUtil.hasErrorElements(child)) continue;
            return true;
        }
        return false;
    }

    public static PsiElement[] filterAncestors(PsiElement[] elements) {
        int previousSize;
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : elements) {
                LOG.debug("element = " + element);
            }
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, (Object[])elements);
        block1: do {
            previousSize = filteredElements.size();
            for (PsiElement element : filteredElements) {
                for (PsiElement element2 : filteredElements) {
                    if (element == element2 || !PsiTreeUtil.isAncestor(element, element2, false)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("removing " + element2);
                    }
                    filteredElements.remove(element2);
                    continue block1;
                }
            }
        } while (filteredElements.size() != previousSize);
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : filteredElements) {
                LOG.debug("filtered element = " + element);
            }
        }
        return PsiUtilCore.toPsiElementArray(filteredElements);
    }

    public static boolean treeWalkUp(PsiScopeProcessor processor, PsiElement entrance, PsiElement maxScope, ResolveState state) {
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!scope.processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(PsiElement entrance, PsiElement maxScope, PairProcessor<PsiElement, PsiElement> eachScopeAndLastParent) {
        PsiElement prevParent = null;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!eachScopeAndLastParent.process((Object)scope, prevParent)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static PsiElement findPrevParent(PsiElement ancestor, PsiElement descendant) {
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent = cur.getParent();
            if (parent == ancestor) {
                return cur;
            }
            cur = parent;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static List<PsiElement> getInjectedElements(OuterLanguageElement outerLanguageElement) {
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList res = ContainerUtil.newArrayList();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element = psi.findElementAt(injectionRange.getStartOffset()); element != null && injectionRange.intersectsStrict(element.getTextRange()); element = element.getNextSibling()) {
            res.add(element);
        }
        return res;
    }
}

