/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ReferenceSetBase<T extends PsiReference> {
    public static final char DOT_SEPARATOR = '.';
    private final List<T> myReferences;
    private final PsiElement myElement;
    private final char mySeparator;

    public ReferenceSetBase(PsiElement element) {
        this(element, ElementManipulators.getOffsetInElement(element));
    }

    public ReferenceSetBase(PsiElement element, int offset) {
        this(ElementManipulators.getValueText(element), element, offset, '.');
    }

    public ReferenceSetBase(String text, PsiElement element, int offset, char separator) {
        this.myElement = element;
        this.mySeparator = separator;
        this.myReferences = this.parse(text, offset);
    }

    public boolean isSoft() {
        return true;
    }

    protected List<T> parse(String str, int offset) {
        int next;
        ArrayList<T> references = new ArrayList<T>();
        int current = -1;
        int index = 0;
        do {
            TextRange range = new TextRange(offset + current + 1, offset + ((next = this.findNextSeparator(str, current)) >= 0 ? next : str.length()));
            references.addAll(this.createReferences(range, index++));
        } while ((current = next) >= 0);
        return references;
    }

    protected int findNextSeparator(String str, int current) {
        int next = str.indexOf(this.mySeparator, current + 1);
        return next;
    }

    protected T createReference(TextRange range, int index) {
        return null;
    }

    protected List<T> createReferences(TextRange range, int index) {
        T reference = this.createReference(range, index);
        return reference == null ? Collections.emptyList() : Collections.singletonList(reference);
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public List<T> getReferences() {
        return this.myReferences;
    }

    public PsiReference[] getPsiReferences() {
        return this.myReferences.toArray(new PsiReference[this.myReferences.size()]);
    }

    public T getReference(int index) {
        return (T)((PsiReference)this.myReferences.get(index));
    }

    public T getLastReference() {
        return this.myReferences.isEmpty() ? null : (T)this.getReference(this.myReferences.size() - 1);
    }
}

