/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.LinkedHashMap;

public class RenameInputValidatorRegistry {
    private RenameInputValidatorRegistry() {
    }

    public static Condition<String> getInputValidator(final PsiElement element) {
        final LinkedHashMap acceptedValidators = new LinkedHashMap();
        for (RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            ProcessingContext context = new ProcessingContext();
            if (!validator.getPattern().accepts(element, context)) continue;
            acceptedValidators.put((Object)validator, (Object)context);
        }
        return acceptedValidators.isEmpty() ? null : new Condition<String>(){

            public boolean value(String s) {
                for (RenameInputValidator validator : acceptedValidators.keySet()) {
                    if (validator.isInputValid(s, element, (ProcessingContext)acceptedValidators.get((Object)validator))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Function<String, String> getInputErrorValidator(final PsiElement element) {
        final LinkedHashMap acceptedValidators = new LinkedHashMap();
        for (RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            ProcessingContext context = new ProcessingContext();
            if (!(validator instanceof RenameInputValidatorEx) || !validator.getPattern().accepts(element, context)) continue;
            acceptedValidators.put((Object)((RenameInputValidatorEx)validator), (Object)context);
        }
        return acceptedValidators.isEmpty() ? null : new Function<String, String>(){

            public String fun(String newName) {
                for (RenameInputValidatorEx validator : acceptedValidators.keySet()) {
                    String message = validator.getErrorMessage(newName, element.getProject());
                    if (message == null) continue;
                    return message;
                }
                return null;
            }
        };
    }
}

