/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;

public class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(String title, String message, @NonNls String helpId, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, new Comparator<UsageInfo>(){

            @Override
            public int compare(UsageInfo usage1, UsageInfo usage2) {
                PsiElement element1 = usage1.getElement();
                PsiElement element2 = usage2.getElement();
                if (element1 == null) {
                    if (element2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (element2 == null) {
                    return -1;
                }
                return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
            }
        });
    }

    public static void showErrorHint(final Project project, final Editor editor, final String message, final String title, final @NonNls String helpId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (editor == null || editor.getComponent().getRootPane() == null) {
                    CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
                } else {
                    HintManager.getInstance().showErrorHint(editor, message);
                }
            }
        });
    }

    @NonNls
    public static String htmlEmphasize(String text) {
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(PsiElement element) {
        VirtualFile file = element.getContainingFile().getVirtualFile();
        return file != null && !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(file).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(Project project, PsiElement element) {
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(Project project, PsiElement ... elements) {
        return CommonRefactoringUtil.checkReadOnlyStatus(Arrays.asList(elements), project, RefactoringBundle.message("refactoring.cannot.be.performed"), false, true);
    }

    public static boolean checkReadOnlyStatus(PsiElement element, Project project, String messagePrefix) {
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(Collections.singleton(element), project, messagePrefix, false, true);
    }

    public static boolean checkReadOnlyStatusRecursively(Project project, Collection<? extends PsiElement> elements) {
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, false);
    }

    public static boolean checkReadOnlyStatusRecursively(Project project, Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        return CommonRefactoringUtil.checkReadOnlyStatus(elements, project, RefactoringBundle.message("refactoring.cannot.be.performed"), true, notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(Collection<? extends PsiElement> elements, Project project, String messagePrefix, boolean recursively, boolean notifyOnFail) {
        THashSet readonly = new THashSet();
        THashSet failed = new THashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            VirtualFile vFile;
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                vFile = dir.getVirtualFile();
                if (vFile.getFileSystem() instanceof JarFileSystem) {
                    failed.add(vFile);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(vFile, (Collection<VirtualFile>)readonly);
                    continue;
                }
                readonly.add(vFile);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                            failed.add(virtualFile);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, (Collection<VirtualFile>)readonly);
                        continue;
                    }
                    if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                        failed.add(virtualFile);
                        continue;
                    }
                    readonly.add(virtualFile);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            vFile = file.getVirtualFile();
            if (vFile != null) {
                readonly.add(vFile);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        VirtualFile[] files = VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)readonly);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(files);
        ContainerUtil.addAll((Collection)failed, (Object[])operationStatus.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder message = new StringBuilder(messagePrefix);
            message.append('\n');
            int i = 0;
            for (VirtualFile virtualFile : failed) {
                String subj;
                String presentableUrl = virtualFile.getPresentableUrl();
                String string = subj = virtualFile.isDirectory() ? RefactoringBundle.message("directory.description", presentableUrl) : RefactoringBundle.message("file.description", presentableUrl);
                if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                    message.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj));
                } else {
                    message.append(RefactoringBundle.message("0.is.read.only", subj));
                }
                if (i++ <= 20) continue;
                message.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), message.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    public static void collectReadOnlyFiles(VirtualFile vFile, final Collection<VirtualFile> list) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(VirtualFile file) {
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }
        });
    }

    public static String capitalize(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    public static boolean isAncestor(PsiElement resolved, Collection<? extends PsiElement> scopes) {
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

