/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;

public class MoveRenameUsageInfo
extends UsageInfo {
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveRenameUsageInfo.class.getName()));
    private SmartPsiElementPointer myReferencedElementPointer = null;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker = null;

    public MoveRenameUsageInfo(PsiReference reference, PsiElement referencedElement) {
        this(reference.getElement(), reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        super(element);
        this.init(element, reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        super(element, startOffset, endOffset, nonCodeUsage);
        this.init(element, reference, referencedElement);
    }

    private void init(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        TextRange textRange;
        Project project = element.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(referencedElement);
        }
        if (reference == null) {
            reference = element.getReference();
        }
        PsiFile containingFile = element.getContainingFile();
        if (reference == null && (textRange = element.getTextRange()) != null) {
            reference = containingFile.findReferenceAt(textRange.getStartOffset());
        }
        this.myReference = reference;
        if (reference != null) {
            Document document = PsiDocumentManager.getInstance(project).getDocument(containingFile);
            if (document != null) {
                TextRange rangeInElement;
                int elementStart = reference.getElement().getTextRange().getStartOffset();
                LOG.assertTrue(elementStart + (rangeInElement = reference.getRangeInElement()).getEndOffset() <= document.getTextLength(), (Object)reference);
                this.myReferenceRangeMarker = document.createRangeMarker(elementStart + rangeInElement.getStartOffset(), elementStart + rangeInElement.getEndOffset());
            }
            this.myDynamicUsage = reference.resolve() == null;
        }
    }

    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : (PsiElement)this.myReferencedElementPointer.getElement();
    }

    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Override
    public PsiReference getReference() {
        PsiElement element;
        if (this.myReference != null && (element = this.myReference.getElement()) != null && element.isValid()) {
            if (this.myReferenceRangeMarker == null) {
                return this.myReference;
            }
            PsiReference reference = this.checkReferenceRange(element, new Function<Integer, PsiReference>(){

                public PsiReference fun(Integer start) {
                    return MoveRenameUsageInfo.this.myReference;
                }
            });
            if (reference != null) {
                return reference;
            }
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return this.checkReferenceRange(element, new Function<Integer, PsiReference>(){

            public PsiReference fun(Integer start) {
                return element.findReferenceAt(start);
            }
        });
    }

    private PsiReference checkReferenceRange(PsiElement element, Function<Integer, PsiReference> fn) {
        int start = this.myReferenceRangeMarker.getStartOffset() - element.getTextRange().getStartOffset();
        int end = this.myReferenceRangeMarker.getEndOffset() - element.getTextRange().getStartOffset();
        PsiReference reference = (PsiReference)fn.fun((Object)start);
        if (reference == null) {
            return null;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        if (rangeInElement.getStartOffset() != start || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference;
    }
}

