/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;

public class NonCodeUsageInfo
extends MoveRenameUsageInfo {
    public final String newText;

    private NonCodeUsageInfo(PsiElement element, int startOffset, int endOffset, PsiElement referencedElement, String newText) {
        super(element, null, startOffset, endOffset, referencedElement, true);
        this.newText = newText;
    }

    public static NonCodeUsageInfo create(PsiFile file, int startOffset, int endOffset, PsiElement referencedElement, String newText) {
        TextRange range;
        PsiElement element;
        for (element = file.findElementAt(startOffset); element != null && (range = element.getTextRange()).getEndOffset() < endOffset; element = element.getParent()) {
        }
        if (element == null) {
            return null;
        }
        int elementStart = element.getTextRange().getStartOffset();
        return new NonCodeUsageInfo(element, startOffset -= elementStart, endOffset -= elementStart, referencedElement, newText);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    public NonCodeUsageInfo replaceElement(PsiElement newElement) {
        return new NonCodeUsageInfo(newElement, this.getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset(), this.getReferencedElement(), this.newText);
    }
}

