/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import java.util.Comparator;
import javax.swing.Icon;

public abstract class ServerType<C extends ServerConfiguration> {
    public static final ExtensionPointName<ServerType> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.type");
    private final String myId;

    protected ServerType(String id) {
        this.myId = id;
    }

    public final String getId() {
        return this.myId;
    }

    public abstract String getPresentableName();

    public abstract Icon getIcon();

    public abstract C createDefaultConfiguration();

    public RemoteServerConfigurable createServerConfigurable(C configuration) {
        throw new UnsupportedOperationException();
    }

    public UnnamedConfigurable createConfigurable(C configuration) {
        return this.createServerConfigurable(configuration);
    }

    public abstract DeploymentConfigurator<?, C> createDeploymentConfigurator(Project var1);

    public abstract ServerConnector<?> createConnector(C var1, ServerTaskExecutor var2);

    public ServerConnector<?> createConnector(RemoteServer<C> server, ServerTaskExecutor asyncTasksExecutor) {
        return this.createConnector(server.getConfiguration(), asyncTasksExecutor);
    }

    public DebugConnector<?, ?> createDebugConnector() {
        return null;
    }

    public Comparator<Deployment> getDeploymentComparator() {
        return new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }
}

