/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.PsiTestCase;
import java.io.File;

public abstract class ResolveTestCase
extends PsiTestCase {
    protected static final String MARKER = "<ref>";
    private Document myDocument;

    @Override
    protected void tearDown() throws Exception {
        if (this.myDocument != null) {
            FileDocumentManager.getInstance().reloadFromDisk(this.myDocument);
        }
        super.tearDown();
    }

    protected PsiReference configureByFile(String filePath) throws Exception {
        return this.configureByFile(filePath, null);
    }

    protected PsiReference configureByFile(String filePath, VirtualFile parentDir) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        ResolveTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText(vFile));
        return this.configureByFileText(fileText, vFile.getName(), parentDir);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        return this.configureByFileText(fileText, fileName, null);
    }

    protected PsiReference configureByFileText(String fileText, String fileName, VirtualFile parentDir) throws Exception {
        int offset = fileText.indexOf(MARKER);
        ResolveTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + MARKER.length());
        if (parentDir == null) {
            this.myFile = this.createFile(this.myModule, fileName, fileText);
        } else {
            VirtualFile existing = parentDir.findChild(fileName);
            if (existing != null) {
                this.myDocument = FileDocumentManager.getInstance().getDocument(existing);
                ResolveTestCase.assertNotNull((Object)this.myDocument);
                this.myDocument.setText(fileText);
                this.myFile = PsiManager.getInstance(this.getProject()).findFile(existing);
                ResolveTestCase.assertNotNull((Object)this.myFile);
                ResolveTestCase.assertEquals((String)fileText, (String)this.myFile.getText());
            } else {
                this.myFile = this.createFile(this.myModule, parentDir, fileName, fileText);
            }
        }
        PsiReference ref = this.myFile.findReferenceAt(offset);
        ResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    @Override
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/psi/resolve/";
    }
}

