/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.inline.InlineConstantFieldProcessor;
import com.intellij.refactoring.inline.InlineLocalHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineParameterHandler;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;

public class JavaCodeInsightTestUtil {
    private static final int TARGET_FOR_INLINE_FLAGS = 3;

    private JavaCodeInsightTestUtil() {
    }

    public static void doInlineLocalTest(final CodeInsightTestFixture fixture, String before, String after) {
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                PsiElement element = TargetElementUtilBase.findTargetElement((Editor)editor, (int)3);
                assert (element instanceof PsiLocalVariable) : element;
                InlineLocalHandler.invoke((Project)fixture.getProject(), (Editor)editor, (PsiLocalVariable)((PsiLocalVariable)element), null);
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineParameterTest(final CodeInsightTestFixture fixture, String before, String after) {
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                PsiElement element = TargetElementUtilBase.findTargetElement((Editor)editor, (int)3);
                assert (element instanceof PsiParameter) : element;
                new InlineParameterHandler().inlineElement(this.getProject(), editor, element);
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineMethodTest(final CodeInsightTestFixture fixture, String before, String after) {
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                PsiElement element = TargetElementUtilBase.findTargetElement((Editor)editor, (int)3);
                assert (element instanceof PsiMethod) : element;
                PsiReference ref = fixture.getFile().findReferenceAt(editor.getCaretModel().getOffset());
                PsiReferenceExpression refExpr = ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
                PsiMethod method = (PsiMethod)element;
                assert (!InlineMethodProcessor.checkBadReturns((PsiMethod)method) || InlineUtil.allUsagesAreTailCalls((PsiMethod)method)) : "Bad returns found";
                new InlineMethodProcessor(this.getProject(), method, (PsiJavaCodeReferenceElement)refExpr, editor, false).run();
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineConstantTest(final CodeInsightTestFixture fixture, String before, String after) {
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                PsiElement element = TargetElementUtilBase.findTargetElement((Editor)editor, (int)3);
                assert (element instanceof PsiField) : element;
                PsiReference ref = fixture.getFile().findReferenceAt(editor.getCaretModel().getOffset());
                PsiReferenceExpression refExpr = ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
                new InlineConstantFieldProcessor((PsiField)element, this.getProject(), refExpr, false).run();
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }
}

