/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;

public abstract class AutoScrollFromSourceHandler
implements Disposable {
    protected final Project myProject;
    protected final Alarm myAlarm;
    private JComponent myComponent;

    public AutoScrollFromSourceHandler(Project project, JComponent view) {
        this(project, view, null);
    }

    public AutoScrollFromSourceHandler(Project project, JComponent view, Disposable parentDisposable) {
        this.myProject = project;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        this.myComponent = view;
        this.myAlarm = new Alarm(this);
    }

    protected abstract boolean isAutoScrollEnabled();

    protected abstract void setAutoScrollEnabled(boolean var1);

    protected abstract void selectElementFromEditor(FileEditor var1);

    protected ModalityState getModalityState() {
        return ModalityState.current();
    }

    protected long getAlarmDelay() {
        return 500L;
    }

    public void install() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            @Override
            public void selectionChanged(FileEditorManagerEvent event) {
                final FileEditor editor = event.getNewEditor();
                if (editor != null && AutoScrollFromSourceHandler.this.myComponent.isShowing() && AutoScrollFromSourceHandler.this.isAutoScrollEnabled()) {
                    AutoScrollFromSourceHandler.this.myAlarm.cancelAllRequests();
                    AutoScrollFromSourceHandler.this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            AutoScrollFromSourceHandler.this.selectElementFromEditor(editor);
                        }
                    }, AutoScrollFromSourceHandler.this.getAlarmDelay(), AutoScrollFromSourceHandler.this.getModalityState());
                }
            }
        });
    }

    public void dispose() {
        if (!this.myAlarm.isDisposed()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public ToggleAction createToggleAction() {
        return new AutoScrollFromSourceAction();
    }

    private class AutoScrollFromSourceAction
    extends ToggleAction
    implements DumbAware {
        public AutoScrollFromSourceAction() {
            super(UIBundle.message((String)"autoscroll.from.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.from.source.action.description", (Object[])new Object[0]), AllIcons.General.AutoscrollFromSource);
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return AutoScrollFromSourceHandler.this.isAutoScrollEnabled();
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AutoScrollFromSourceHandler.this.setAutoScrollEnabled(flag);
        }
    }
}

