/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.TableCell;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;

public abstract class ExpandableItemsHandlerFactory {
    private static final ExpandableItemsHandler NULL = new ExpandableItemsHandler<Object>(){

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Collection<Object> getExpandedItems() {
            return Collections.emptyList();
        }
    };

    public static ExpandableItemsHandler<Integer> install(JList list) {
        ExpandableItemsHandlerFactory i = ExpandableItemsHandlerFactory.getInstance();
        return i == null ? NULL : i.doInstall(list);
    }

    public static ExpandableItemsHandler<Integer> install(JTree tree) {
        ExpandableItemsHandlerFactory i = ExpandableItemsHandlerFactory.getInstance();
        return i == null ? NULL : i.doInstall(tree);
    }

    public static ExpandableItemsHandler<TableCell> install(JTable table) {
        ExpandableItemsHandlerFactory i = ExpandableItemsHandlerFactory.getInstance();
        return i == null ? NULL : i.doInstall(table);
    }

    private static ExpandableItemsHandlerFactory getInstance() {
        if (!Registry.is((String)"ide.windowSystem.showListItemsPopup") || ApplicationManager.getApplication() == null) {
            return null;
        }
        return ServiceManager.getService(ExpandableItemsHandlerFactory.class);
    }

    protected abstract ExpandableItemsHandler<Integer> doInstall(JList var1);

    protected abstract ExpandableItemsHandler<Integer> doInstall(JTree var1);

    protected abstract ExpandableItemsHandler<TableCell> doInstall(JTable var1);
}

