/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;

public class PathsChooserComponent
implements ComponentWithEmptyText {
    private JPanel myContentPane;
    private JBList myList = new JBList();
    private final DefaultListModel myListModel;
    private List<String> myWorkingCollection;
    private final List<String> myInitialCollection;
    private final Project myProject;

    public PathsChooserComponent(List<String> collection, PathProcessor processor) {
        this(collection, processor, null);
    }

    public PathsChooserComponent(List<String> collection, final PathProcessor processor, Project project) {
        this.myList.setSelectionMode(0);
        this.myInitialCollection = collection;
        this.myProject = project;
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        this.myListModel = new DefaultListModel();
        this.myList.setModel(this.myListModel);
        this.myContentPane = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor dirChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                dirChooser.setShowFileSystemRoots(true);
                dirChooser.setHideIgnored(true);
                dirChooser.setTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
                FileChooser.chooseFiles(dirChooser, PathsChooserComponent.this.myProject, null, new Consumer<List<VirtualFile>>(){

                    public void consume(List<VirtualFile> files) {
                        for (VirtualFile file : files) {
                            String path = file.getPath();
                            if (!processor.addPath(PathsChooserComponent.this.myWorkingCollection, path)) continue;
                            PathsChooserComponent.this.myListModel.addElement(path);
                        }
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selected = PathsChooserComponent.this.myList.getSelectedIndex();
                if (selected != -1) {
                    String path = (String)PathsChooserComponent.this.myListModel.get(selected);
                    if (processor.removePath(PathsChooserComponent.this.myWorkingCollection, path)) {
                        PathsChooserComponent.this.myListModel.remove(selected);
                    }
                }
            }
        }).createPanel();
        this.reset();
    }

    @Override
    public StatusText getEmptyText() {
        return this.myList.getEmptyText();
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public List<String> getValues() {
        return this.myWorkingCollection;
    }

    public void reset() {
        this.myListModel.clear();
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        for (String path : this.myWorkingCollection) {
            this.myListModel.addElement(path);
        }
    }

    public boolean isModified() {
        return !((Object)this.myWorkingCollection).equals(this.myInitialCollection);
    }

    public void apply() {
        this.myInitialCollection.clear();
        this.myInitialCollection.addAll(this.myWorkingCollection);
    }

    public static interface PathProcessor {
        public boolean addPath(List<String> var1, String var2);

        public boolean removePath(List<String> var1, String var2);
    }
}

