/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SuitableFontProvider;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;

public class SimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SimpleColoredComponent");
    public static final Color SHADOW_COLOR;
    public static final Color STYLE_SEARCH_MATCH_BACKGROUND;
    public static final int FRAGMENT_ICON = -2;
    private final List<String> myFragments;
    private final List<SimpleTextAttributes> myAttributes;
    private List<Object> myFragmentTags = null;
    private TIntIntHashMap myFragmentAlignment;
    private Icon myIcon;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border myBorder;
    private boolean mySupportFontFallback = false;
    private int myMainTextLastIndex = -1;
    private final TIntIntHashMap myFragmentPadding;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque = false;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private final AccessibleContext myContext = new MyAccessibleContext();
    private boolean myIconOnTheRight = false;
    private boolean myTransparentIconBackground;

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList<String>(3);
        this.myAttributes = new ArrayList<SimpleTextAttributes>(3);
        this.myIpad = new JBInsets(1, 2, 1, 2);
        this.myIconTextGap = JBUI.scale((int)2);
        this.myBorder = new MyBorder();
        this.myFragmentPadding = new TIntIntHashMap(10);
        this.myFragmentAlignment = new TIntIntHashMap(10);
        this.setOpaque(true);
    }

    public ColoredIterator iterator() {
        return new MyIterator();
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    public final SimpleColoredComponent append(String fragment) {
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return this;
    }

    @Override
    public final void append(String fragment, SimpleTextAttributes attributes) {
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(String fragment, SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(String fragment, SimpleTextAttributes attributes, boolean isMainText) {
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(String fragment, SimpleTextAttributes attributes, boolean isMainText) {
        this.myFragments.add(fragment);
        this.myAttributes.add(attributes);
        if (isMainText) {
            this.myMainTextLastIndex = this.myFragments.size() - 1;
        }
    }

    private void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    @Override
    public void append(String fragment, SimpleTextAttributes attributes, Object tag) {
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(String fragment, SimpleTextAttributes attributes, Object tag) {
        this.append(fragment, attributes);
        if (this.myFragmentTags == null) {
            this.myFragmentTags = new ArrayList<Object>();
        }
        while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
            this.myFragmentTags.add(null);
        }
        this.myFragmentTags.add(tag);
    }

    @Deprecated
    public synchronized void appendFixedTextFragmentWidth(int width) {
        this.appendTextPadding(width);
    }

    public synchronized void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    public synchronized void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        int alignIndex = this.myFragments.size() - 1;
        this.myFragmentPadding.put(alignIndex, padding);
        this.myFragmentAlignment.put(alignIndex, align);
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    private synchronized void _clear() {
        this.myIcon = null;
        this.myPaintFocusBorder = false;
        this.myFragments.clear();
        this.myAttributes.clear();
        this.myFragmentTags = null;
        this.myMainTextLastIndex = -1;
        this.myFragmentPadding.clear();
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public final void setIcon(Icon icon) {
        this.myIcon = icon;
        this.revalidateAndRepaint();
    }

    public Insets getIpad() {
        return this.myIpad;
    }

    public void setIpad(Insets ipad) {
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.computePreferredSize(false);
    }

    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        if (this.myIcon != null) {
            width += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        Insets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        width += borderInsets.left;
        Font font = this.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        LOG.assertTrue(font != null);
        width += this.computeTextWidth(font, mainTextOnly);
        width += this.myIpad.right + borderInsets.right;
        int height = this.myIpad.top + this.myIpad.bottom;
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = metrics.getHeight();
        height = this.myIcon != null ? (height += Math.max(this.myIcon.getIconHeight(), textHeight)) : (height += (textHeight += borderInsets.top + borderInsets.bottom));
        Insets insets = this.getInsets();
        if (insets != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    private int computeTextWidth(Font font, boolean mainTextOnly) {
        int result = 0;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            int fixedWidth = this.myFragmentPadding.get(i);
            if (fixedWidth > 0 && (result += this.computeStringWidth(this.myFragments.get(i), font)) < fixedWidth) {
                result = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result;
    }

    private void doDrawString(Graphics2D g, String text, int x, int y) {
        Font font = g.getFont();
        if (this.needFontFallback(font, text)) {
            TextLayout layout = this.createTextLayout(text, font, g.getFontRenderContext());
            if (layout != null) {
                layout.draw(g, x, y);
            }
        } else {
            g.drawString(text, x, y);
        }
    }

    private int computeStringWidth(String text, Font font) {
        if (this.needFontFallback(font, text)) {
            TextLayout layout = this.createTextLayout(text, font, this.getFontMetrics(font).getFontRenderContext());
            return layout != null ? (int)layout.getAdvance() : 0;
        }
        return this.getFontMetrics(font).stringWidth(text);
    }

    private TextLayout createTextLayout(String text, Font basefont, FontRenderContext fontRenderContext) {
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        AttributedString string = new AttributedString(text);
        int start = 0;
        int end = text.length();
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], start, end);
        Font currentFont = basefont;
        int currentIndex = start;
        char c = it.first();
        while (c != '\uffff') {
            Font font = basefont;
            if (!font.canDisplay(c)) {
                SuitableFontProvider provider;
                SuitableFontProvider[] arr$ = (SuitableFontProvider[])SuitableFontProvider.EP_NAME.getExtensions();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (font = (provider = arr$[i$]).getFontAbleToDisplay(c, basefont.getSize(), basefont.getStyle(), basefont.getFamily())) == null; ++i$) {
                }
            }
            int i = it.getIndex();
            if (!Comparing.equal((Object)currentFont, (Object)font)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        return new TextLayout(string.getIterator(), fontRenderContext);
    }

    private boolean needFontFallback(Font font, String text) {
        return this.mySupportFontFallback && font.canDisplayUpTo(text) != -1 && text.indexOf(65535) == -1;
    }

    public void setSupportFontFallback(boolean supportFontFallback) {
        this.mySupportFontFallback = supportFontFallback;
    }

    public int findFragmentAt(int x) {
        Font font;
        int curX = this.myIpad.left;
        if (this.myIcon != null && !this.myIconOnTheRight) {
            int iconRight = this.myIcon.getIconWidth() + this.myIconTextGap;
            if (x < iconRight) {
                return -2;
            }
            curX += iconRight;
        }
        if ((font = this.getFont()) == null) {
            font = UIUtil.getLabelFont();
        }
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            int curWidth = this.computeStringWidth(this.myFragments.get(i), font);
            if (x >= curX && x < curX + curWidth) {
                return i;
            }
            int fragmentPadding = this.myFragmentPadding.get(i);
            if (fragmentPadding <= 0 || (curX += curWidth) >= fragmentPadding) continue;
            curX = fragmentPadding;
        }
        if (this.myIcon != null && this.myIconOnTheRight && x >= (curX += this.myIconTextGap) && x < curX + this.myIcon.getIconWidth()) {
            return -2;
        }
        return -1;
    }

    public Object getFragmentTagAt(int x) {
        int index = this.findFragmentAt(x);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    protected JLabel formatToLabel(JLabel label) {
        label.setIcon(this.myIcon);
        if (!this.myFragments.isEmpty()) {
            StringBuilder text = new StringBuilder();
            text.append("<html><body style=\"white-space:nowrap\">");
            for (int i = 0; i < this.myFragments.size(); ++i) {
                String fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = this.myAttributes.get(i);
                Object tag = this.getFragmentTag(i);
                if (tag instanceof BrowserLauncherTag) {
                    SimpleColoredComponent.formatLink(text, fragment, attributes, ((BrowserLauncherTag)tag).myUrl);
                    continue;
                }
                SimpleColoredComponent.formatText(text, fragment, attributes);
            }
            text.append("</body></html>");
            label.setText(text.toString());
        }
        return label;
    }

    static void formatText(StringBuilder builder, String fragment, SimpleTextAttributes attributes) {
        if (!fragment.isEmpty()) {
            builder.append("<span");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(StringBuilder builder, String fragment, SimpleTextAttributes attributes, String url) {
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(String fragment) {
        return StringUtil.escapeXml((String)fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:#").append(Integer.toString(fgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:#").append(Integer.toString(bgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this._doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    private synchronized void _doPaint(Graphics g) {
        SimpleColoredComponent.checkCanPaint(g);
        this.doPaint((Graphics2D)g);
    }

    protected void doPaint(Graphics2D g) {
        int offset = 0;
        Icon icon = this.myIcon;
        if (icon != null && !this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, 0);
            offset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
        }
        this.doPaintTextBackground(g, offset);
        offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon == null);
        if (icon != null && this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, offset);
        }
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(Graphics2D g, Icon icon, int offset) {
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    protected int doPaintText(Graphics2D g, int offset, boolean focusAroundIcon) {
        if (offset == 0) {
            offset = this.myIpad.left;
        }
        int textStart = offset;
        if (this.myBorder != null) {
            offset += this.myBorder.getBorderInsets((Component)this).left;
        }
        ArrayList<Object[]> searchMatches = new ArrayList<Object[]>();
        UIUtil.applyRenderingHints((Graphics)g);
        this.applyAdditionalHints(g);
        Font ownFont = this.getFont();
        if (ownFont != null) {
            offset += this.computeTextAlignShift(ownFont);
        }
        int baseSize = ownFont != null ? ownFont.getSize() : g.getFont().getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            int endOffset;
            Color color;
            Color bgColor;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = g.getFont();
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics(font);
            String fragment = this.myFragments.get(i);
            int fragmentWidth = this.computeStringWidth(fragment, font);
            int fragmentPadding = this.myFragmentPadding.get(i);
            Color color2 = bgColor = attributes.isSearchMatch() ? null : attributes.getBgColor();
            if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(offset, 0, fragmentWidth, this.getHeight());
            }
            if ((color = attributes.getFgColor()) == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getInactiveTextColor();
            }
            g.setColor(color);
            int textBaseline = SimpleColoredComponent.getTextBaseLine(metrics, this.getHeight());
            int fragmentAlignment = this.myFragmentAlignment.get(i);
            if (fragmentPadding > 0 && fragmentPadding > fragmentWidth) {
                endOffset = fragmentPadding;
                if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                    offset = fragmentPadding - fragmentWidth;
                }
            } else {
                endOffset = offset + fragmentWidth;
            }
            if (!attributes.isSearchMatch()) {
                if (this.shouldDrawMacShadow()) {
                    g.setColor(SHADOW_COLOR);
                    this.doDrawString(g, fragment, offset, textBaseline + 1);
                }
                if (this.shouldDrawDimmed()) {
                    color = ColorUtil.dimmer((Color)color);
                }
                g.setColor(color);
                this.doDrawString(g, fragment, offset, textBaseline);
            }
            g.setStroke(g.getStroke());
            if (attributes.isStrikeout()) {
                int strikeOutAt = textBaseline + (metrics.getDescent() - metrics.getAscent()) / 2;
                UIUtil.drawLine((Graphics)g, (int)offset, (int)strikeOutAt, (int)(offset + fragmentWidth), (int)strikeOutAt);
            }
            if (attributes.isWaved()) {
                if (attributes.getWaveColor() != null) {
                    g.setColor(attributes.getWaveColor());
                }
                UIUtil.drawWave((Graphics2D)g, (Rectangle)new Rectangle(offset, textBaseline + 1, fragmentWidth, Math.max(2, metrics.getDescent())));
            }
            if (attributes.isUnderline()) {
                int underlineAt = textBaseline + 1;
                UIUtil.drawLine((Graphics)g, (int)offset, (int)underlineAt, (int)(offset + fragmentWidth), (int)underlineAt);
            }
            if (attributes.isBoldDottedLine()) {
                int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
                Color lineColor = attributes.getWaveColor();
                UIUtil.drawBoldDottedLine((Graphics2D)g, (int)offset, (int)(offset + fragmentWidth), (int)dottedAt, (Color)bgColor, (Color)lineColor, (boolean)this.isOpaque());
            }
            if (attributes.isSearchMatch()) {
                searchMatches.add(new Object[]{offset, offset + fragmentWidth, textBaseline, fragment, g.getFont()});
            }
            offset = endOffset;
        }
        if (this.myPaintFocusBorder && this.myBorder != null) {
            if (focusAroundIcon) {
                this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.myBorder.paintBorder(this, g, textStart, 0, this.getWidth() - textStart, this.getHeight());
            }
        }
        for (Object[] info : searchMatches) {
            UIUtil.drawSearchMatch((Graphics2D)g, (int)((Integer)info[0]), (int)((Integer)info[1]), (int)this.getHeight());
            g.setFont((Font)info[4]);
            if (this.shouldDrawMacShadow()) {
                g.setColor(SHADOW_COLOR);
                g.drawString((String)info[3], (int)((Integer)info[0]), (Integer)info[2] + 1);
            }
            g.setColor((Color)new JBColor((Color)Gray._50, (Color)Gray._0));
            g.drawString((String)info[3], (int)((Integer)info[0]), (int)((Integer)info[2]));
        }
        return offset;
    }

    private int computeTextAlignShift(Font font) {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        int textWidth = this.computeTextWidth(font, false);
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(Graphics g, Icon icon, int offset) {
        icon.paintIcon(this, g, offset, (this.getHeight() - icon.getIconHeight()) / 2);
    }

    protected void applyAdditionalHints(Graphics2D g) {
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return SimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public static int getTextBaseLine(FontMetrics metrics, int height) {
        return (height - metrics.getHeight()) / 2 + metrics.getAscent();
    }

    private static void checkCanPaint(Graphics g) {
        if (UIUtil.isPrinting((Graphics)g)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected void setBorderInsets(Insets insets) {
        if (this.myBorder instanceof MyBorder) {
            ((MyBorder)this.myBorder).setInsets(insets);
        }
        this.revalidateAndRepaint();
    }

    public CharSequence getCharSequence(boolean mainOnly) {
        List<String> fragments = mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size() ? this.myFragments.subList(0, this.myMainTextLastIndex + 1) : this.myFragments;
        return StringUtil.join(fragments, (String)"");
    }

    @Override
    public String toString() {
        return ((Object)this.getCharSequence(false)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(Runnable runnable, boolean autoInvalidate) {
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.myContext;
    }

    static {
        STYLE_SEARCH_MATCH_BACKGROUND = SHADOW_COLOR = new JBColor(new Color(250, 250, 250, 140), Gray._0.withAlpha(50));
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        @Override
        public String getFragment() {
            return (String)SimpleColoredComponent.this.myFragments.get(this.myIndex);
        }

        @Override
        public SimpleTextAttributes getTextAttributes() {
            return (SimpleTextAttributes)SimpleColoredComponent.this.myAttributes.get(this.myIndex);
        }

        @Override
        public int split(int offset, SimpleTextAttributes attributes) {
            if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
            }
            if (offset == this.myEndOffset - this.myOffset) {
                SimpleColoredComponent.this.myAttributes.set(this.myIndex, attributes);
            } else if (offset > 0) {
                String text = this.getFragment();
                SimpleColoredComponent.this.myFragments.set(this.myIndex, text.substring(0, offset));
                SimpleColoredComponent.this.myAttributes.add(this.myIndex, attributes);
                SimpleColoredComponent.this.myFragments.add(this.myIndex + 1, text.substring(offset));
                if (SimpleColoredComponent.this.myFragmentTags != null && SimpleColoredComponent.this.myFragmentTags.size() > this.myIndex) {
                    SimpleColoredComponent.this.myFragmentTags.add(this.myIndex, SimpleColoredComponent.this.myFragments.get(this.myIndex));
                }
                ++this.myIndex;
            }
            this.myOffset += offset;
            return this.myOffset;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex + 1 < SimpleColoredComponent.this.myFragments.size();
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        public String getFragment();

        public SimpleTextAttributes getTextAttributes();

        public int split(int var1, SimpleTextAttributes var2);
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(String url) {
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse(this.myUrl);
        }
    }

    private static class MyAccessibleContext
    extends AccessibleContext {
        private MyAccessibleContext() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }

    private static final class MyBorder
    implements Border {
        private Insets myInsets = new JBInsets(1, 1, 1, 1);

        public void setInsets(Insets insets) {
            this.myInsets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.BLACK);
            UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)(y + height - 1));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return (Insets)this.myInsets.clone();
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

