/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.tree.TreeUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class TreeToolbarDecorator
extends ToolbarDecorator {
    private final JTree myTree;
    private final ElementProducer<?> myProducer;

    TreeToolbarDecorator(JTree tree, ElementProducer<?> producer) {
        this.myTree = tree;
        this.myProducer = producer;
        this.myUpActionEnabled = this.myDownActionEnabled = this.myTree.getModel() instanceof EditableTreeModel;
        this.myRemoveActionEnabled = this.myDownActionEnabled;
        this.myAddActionEnabled = this.myDownActionEnabled;
        if (this.myTree.getModel() instanceof EditableTreeModel) {
            this.createDefaultTreeActions();
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
        this.myTree.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
    }

    private void createDefaultTreeActions() {
        final EditableTreeModel model = (EditableTreeModel)this.myTree.getModel();
        this.myAddAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object element;
                TreePath path = TreeToolbarDecorator.this.myTree.getSelectionPath();
                DefaultMutableTreeNode selected = path == null ? (DefaultMutableTreeNode)TreeToolbarDecorator.this.myTree.getModel().getRoot() : (DefaultMutableTreeNode)path.getLastPathComponent();
                Object selectedNode = selected.getUserObject();
                TreeToolbarDecorator.this.myTree.stopEditing();
                if (model instanceof DefaultTreeModel && TreeToolbarDecorator.this.myProducer != null) {
                    element = TreeToolbarDecorator.this.myProducer.createElement();
                    if (element == null) {
                        return;
                    }
                } else {
                    element = null;
                }
                DefaultMutableTreeNode parent = selected;
                if (selectedNode instanceof SimpleNode && ((SimpleNode)selectedNode).isAlwaysLeaf() || !selected.getAllowsChildren()) {
                    parent = (DefaultMutableTreeNode)selected.getParent();
                }
                if (parent != null) {
                    parent.insert(new DefaultMutableTreeNode(element), parent.getChildCount());
                }
                TreePath createdPath = model.addNode(new TreePath(parent.getPath()));
                if (path != null) {
                    TreeUtil.selectPath(TreeToolbarDecorator.this.myTree, createdPath);
                    TreeToolbarDecorator.this.myTree.requestFocus();
                }
            }
        };
        this.myRemoveAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TreeToolbarDecorator.this.myTree.stopEditing();
                TreePath path = TreeToolbarDecorator.this.myTree.getSelectionPath();
                model.removeNode(path);
            }
        };
    }

    @Override
    public ToolbarDecorator initPosition() {
        return this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.TOP);
    }

    @Override
    protected JComponent getComponent() {
        return this.myTree;
    }

    @Override
    protected void updateButtons() {
        this.getActionsPanel().setEnabled(CommonActionsPanel.Buttons.REMOVE, this.myTree.getSelectionPath() != null);
    }

    @Override
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        this.myTree.setVisibleRowCount(rowCount);
        return this;
    }

    @Override
    protected boolean isModelEditable() {
        return this.myTree.getModel() instanceof EditableModel;
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myTree, (EditableModel)this.myTree.getModel());
    }
}

