/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.AnchorableComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.lang.annotations.JdkConstants;

public class JBLabel
extends JLabel
implements AnchorableComponent {
    private UIUtil.ComponentStyle myComponentStyle = UIUtil.ComponentStyle.REGULAR;
    private UIUtil.FontColor myFontColor = UIUtil.FontColor.NORMAL;
    private JComponent myAnchor = null;

    public JBLabel() {
    }

    public JBLabel(UIUtil.ComponentStyle componentStyle) {
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(Icon image) {
        super(image);
    }

    public JBLabel(String text) {
        super(text);
    }

    public JBLabel(String text, UIUtil.ComponentStyle componentStyle) {
        super(text);
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(String text, UIUtil.ComponentStyle componentStyle, UIUtil.FontColor fontColor) {
        super(text);
        this.setComponentStyle(componentStyle);
        this.setFontColor(fontColor);
    }

    public JBLabel(String text, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public JBLabel(Icon image, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public JBLabel(String text, Icon icon, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public void setComponentStyle(UIUtil.ComponentStyle componentStyle) {
        this.myComponentStyle = componentStyle;
        UIUtil.applyStyle((UIUtil.ComponentStyle)componentStyle, (Component)this);
    }

    public UIUtil.ComponentStyle getComponentStyle() {
        return this.myComponentStyle;
    }

    public UIUtil.FontColor getFontColor() {
        return this.myFontColor;
    }

    public void setFontColor(UIUtil.FontColor fontColor) {
        this.myFontColor = fontColor;
    }

    @Override
    public Color getForeground() {
        if (!this.isEnabled()) {
            return UIUtil.getLabelDisabledForeground();
        }
        if (this.myFontColor != null) {
            return UIUtil.getLabelFontColor((UIUtil.FontColor)this.myFontColor);
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.myFontColor = null;
        super.setForeground(fg);
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myAnchor == null || this.myAnchor == this ? super.getPreferredSize() : this.myAnchor.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.myAnchor == null || this.myAnchor == this ? super.getMinimumSize() : this.myAnchor.getMinimumSize();
    }
}

