/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.util.IconUtil;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JPanel;

public class JBPanel
extends JPanel
implements TypeSafeDataProvider {
    private Icon myBackgroundImage;
    private Icon myCenterImage;

    public JBPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public JBPanel(LayoutManager layout) {
        super(layout);
    }

    public JBPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JBPanel() {
    }

    public Icon getBackgroundImage() {
        return this.myBackgroundImage;
    }

    public void setBackgroundImage(Icon backgroundImage) {
        this.myBackgroundImage = backgroundImage;
    }

    public Icon getCenterImage() {
        return this.myCenterImage;
    }

    public void setCenterImage(Icon centerImage) {
        this.myCenterImage = centerImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Icon image = this.getBackgroundImage();
        if (image != null) {
            int w = image.getIconWidth();
            int h = image.getIconHeight();
            int y = 0;
            for (int x = 0; w > 0 && x < this.getWidth(); x += w) {
                while (h > 0 && y < this.getHeight()) {
                    image.paintIcon(this, g, x, y);
                    y += h;
                }
                y = 0;
            }
        } else {
            super.paintComponent(g);
        }
        this.paintCenterImage(g);
    }

    protected void paintCenterImage(Graphics g) {
        Icon centerImage = this.getCenterImage();
        if (centerImage != null) {
            IconUtil.paintInCenterOf(this, g, centerImage);
        }
    }

    @Override
    public void calcData(DataKey key, DataSink sink) {
    }
}

