/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class HintUpdateSupply {
    private static final Key<HintUpdateSupply> HINT_UPDATE_MARKER = Key.create((String)"HINT_UPDATE_MARKER");
    private JBPopup myHint;

    public static HintUpdateSupply getSupply(JComponent component) {
        return (HintUpdateSupply)component.getClientProperty(HINT_UPDATE_MARKER);
    }

    public static void hideHint(JComponent component) {
        HintUpdateSupply supply = HintUpdateSupply.getSupply(component);
        if (supply != null) {
            supply.hideHint();
        }
    }

    public static void installSimpleHintUpdateSupply(final JComponent component) {
        HintUpdateSupply supply = new HintUpdateSupply(component){

            @Override
            protected PsiElement getPsiElementForHint(Object selectedValue) {
                return selectedValue instanceof PsiElement ? (PsiElement)selectedValue : CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext(component));
            }
        };
        if (component instanceof JList) {
            supply.installListListener((JList)component);
        }
        if (component instanceof JTree) {
            supply.installTreeListener((JTree)component);
        }
        if (component instanceof JTable) {
            supply.installTableListener((JTable)component);
        }
    }

    protected HintUpdateSupply(JComponent component) {
        this.installSupply(component);
    }

    public HintUpdateSupply(JBTable table) {
        this.installSupply(table);
        this.installTableListener(table);
    }

    public HintUpdateSupply(Tree tree) {
        this.installSupply(tree);
        this.installTreeListener(tree);
    }

    public HintUpdateSupply(JBList list) {
        this.installSupply(list);
        this.installListListener(list);
    }

    protected void installTableListener(final JTable table) {
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(table)) {
                    return;
                }
                int selected = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
                int rowCount = table.getRowCount();
                if (selected == -1 || rowCount == 0) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(table.getValueAt(Math.min(selected, rowCount - 1), 0));
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(listener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    protected void installTreeListener(final JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiElement psiElement;
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(tree)) {
                    return;
                }
                TreePath path = tree.getSelectionPath();
                if (path != null && (psiElement = HintUpdateSupply.this.getPsiElementForHint(path.getLastPathComponent())) != null && psiElement.isValid()) {
                    HintUpdateSupply.this.updateHint(psiElement);
                }
            }
        });
    }

    protected void installListListener(final JList list) {
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HintUpdateSupply.isHintVisible(HintUpdateSupply.this.myHint) || HintUpdateSupply.isSelectedByMouse(list)) {
                    return;
                }
                Object[] selectedValues = ((JList)e.getSource()).getSelectedValues();
                if (selectedValues.length != 1) {
                    return;
                }
                PsiElement element = HintUpdateSupply.this.getPsiElementForHint(selectedValues[0]);
                if (element != null && element.isValid()) {
                    HintUpdateSupply.this.updateHint(element);
                }
            }
        });
    }

    protected abstract PsiElement getPsiElementForHint(Object var1);

    private void installSupply(JComponent component) {
        component.putClientProperty(HINT_UPDATE_MARKER, this);
    }

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (HintUpdateSupply.isHintVisible(this.myHint)) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (!HintUpdateSupply.isHintVisible(this.myHint)) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    private static boolean isHintVisible(JBPopup hint) {
        return hint != null && hint.isVisible();
    }

    private static boolean isSelectedByMouse(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty("byMouseEvent"));
    }
}

