/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.popup.util.ItemWrapper;
import javax.swing.JPanel;

public interface DetailView
extends UserDataHolder {
    public Editor getEditor();

    public void navigateInPreviewEditor(PreviewEditorState var1);

    public JPanel getPropertiesPanel();

    public void setPropertiesPanel(JPanel var1);

    public void clearEditor();

    public PreviewEditorState getEditorState();

    public ItemWrapper getCurrentItem();

    public boolean hasEditorOnly();

    public void setCurrentItem(ItemWrapper var1);

    public static class PreviewEditorState {
        public static PreviewEditorState EMPTY = new PreviewEditorState(null, null, null);
        private final VirtualFile myFile;
        private final LogicalPosition myNavigate;
        private final TextAttributes myAttributes;

        public static PreviewEditorState create(VirtualFile file, int line) {
            return new PreviewEditorState(file, line < 0 ? null : new LogicalPosition(line, 0), null);
        }

        public static PreviewEditorState create(VirtualFile file, int line, TextAttributes attributes) {
            return new PreviewEditorState(file, line < 0 ? null : new LogicalPosition(line, 0), attributes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreviewEditorState state = (PreviewEditorState)o;
            if (this.myAttributes != null ? !this.myAttributes.equals(state.myAttributes) : state.myAttributes != null) {
                return false;
            }
            if (this.myFile != null ? !this.myFile.equals(state.myFile) : state.myFile != null) {
                return false;
            }
            return !(this.myNavigate != null ? !this.myNavigate.equals(state.myNavigate) : state.myNavigate != null);
        }

        public int hashCode() {
            int result = this.myFile != null ? this.myFile.hashCode() : 0;
            result = 31 * result + (this.myNavigate != null ? this.myNavigate.hashCode() : 0);
            result = 31 * result + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
            return result;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public LogicalPosition getNavigate() {
            return this.myNavigate;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }

        public PreviewEditorState(VirtualFile file, LogicalPosition navigate, TextAttributes attributes) {
            this.myFile = file;
            this.myNavigate = navigate;
            this.myAttributes = attributes;
        }
    }
}

