/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public abstract class SpeedSearchSupply {
    public static final String SEARCH_QUERY_KEY = "SEARCH_QUERY";
    private static final Key SPEED_SEARCH_COMPONENT_MARKER = new Key("SPEED_SEARCH_COMPONENT_MARKER");
    public static final DataKey<String> SPEED_SEARCH_CURRENT_QUERY = DataKey.create("SPEED_SEARCH_CURRENT_QUERY");

    public static SpeedSearchSupply getSupply(JComponent component) {
        return SpeedSearchSupply.getSupply(component, false);
    }

    public static SpeedSearchSupply getSupply(JComponent component, boolean evenIfInactive) {
        SpeedSearchSupply speedSearch = (SpeedSearchSupply)component.getClientProperty(SPEED_SEARCH_COMPONENT_MARKER);
        if (evenIfInactive) {
            return speedSearch;
        }
        return speedSearch != null && speedSearch.isPopupActive() ? speedSearch : null;
    }

    public abstract Iterable<TextRange> matchingFragments(String var1);

    public abstract void refreshSelection();

    public abstract boolean isPopupActive();

    public String getEnteredPrefix() {
        return null;
    }

    protected void installSupplyTo(final JComponent component) {
        component.putClientProperty(SPEED_SEARCH_COMPONENT_MARKER, this);
        this.addChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.repaint();
            }
        });
    }

    public abstract void addChangeListener(PropertyChangeListener var1);

    public abstract void removeChangeListener(PropertyChangeListener var1);

    public abstract void findAndSelectElement(String var1);
}

