/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.jetbrains.annotations.NonNls;

public class FindUsagesProcessPresentation {
    @NonNls
    public static final String NAME_WITH_MNEMONIC_KEY = "NameWithMnemonic";
    private final UsageViewPresentation myUsageViewPresentation;
    private List<Action> myNotFoundActions;
    private boolean myShowPanelIfOnlyOneUsage;
    private boolean myShowNotFoundMessage;
    private Factory<ProgressIndicator> myProgressIndicatorFactory;
    private Collection<VirtualFile> myLargeFiles;
    private boolean myShowFindOptionsPrompt = true;
    private Runnable mySearchWithProjectFiles;
    private boolean myCanceled;

    public FindUsagesProcessPresentation(UsageViewPresentation presentation) {
        this.myUsageViewPresentation = presentation;
    }

    public void addNotFoundAction(Action action) {
        if (this.myNotFoundActions == null) {
            this.myNotFoundActions = new ArrayList<Action>();
        }
        this.myNotFoundActions.add(action);
    }

    public List<Action> getNotFoundActions() {
        return this.myNotFoundActions == null ? Collections.emptyList() : this.myNotFoundActions;
    }

    public boolean isShowNotFoundMessage() {
        return this.myShowNotFoundMessage;
    }

    public void setShowNotFoundMessage(boolean showNotFoundMessage) {
        this.myShowNotFoundMessage = showNotFoundMessage;
    }

    public boolean isShowPanelIfOnlyOneUsage() {
        return this.myShowPanelIfOnlyOneUsage;
    }

    public void setShowPanelIfOnlyOneUsage(boolean showPanelIfOnlyOneUsage) {
        this.myShowPanelIfOnlyOneUsage = showPanelIfOnlyOneUsage;
    }

    public Factory<ProgressIndicator> getProgressIndicatorFactory() {
        return this.myProgressIndicatorFactory;
    }

    public void setProgressIndicatorFactory(Factory<ProgressIndicator> progressIndicatorFactory) {
        this.myProgressIndicatorFactory = progressIndicatorFactory;
    }

    public Runnable searchIncludingProjectFileUsages() {
        return this.mySearchWithProjectFiles;
    }

    public void projectFileUsagesFound(Runnable searchWithProjectFiles) {
        this.mySearchWithProjectFiles = searchWithProjectFiles;
    }

    public void setLargeFilesWereNotScanned(Collection<VirtualFile> largeFiles) {
        this.myLargeFiles = largeFiles;
    }

    public Collection<VirtualFile> getLargeFiles() {
        return this.myLargeFiles == null ? Collections.emptyList() : this.myLargeFiles;
    }

    public boolean isShowFindOptionsPrompt() {
        return this.myShowFindOptionsPrompt;
    }

    public UsageViewPresentation getUsageViewPresentation() {
        return this.myUsageViewPresentation;
    }

    public void setShowFindOptionsPrompt(boolean showFindOptionsPrompt) {
        this.myShowFindOptionsPrompt = showFindOptionsPrompt;
    }

    public void setCanceled(boolean canceled) {
        this.myCanceled = canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }
}

