/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.reference.SoftReference;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.RenameableUsage;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.awt.Point;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;

public class UsageInfo2UsageAdapter
implements UsageInModule,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage,
Comparable<UsageInfo2UsageAdapter>,
RenameableUsage,
TypeSafeDataProvider,
UsagePresentation {
    public static final NotNullFunction<UsageInfo, Usage> CONVERTER = new NotNullFunction<UsageInfo, Usage>(){

        public Usage fun(UsageInfo usageInfo) {
            return new UsageInfo2UsageAdapter(usageInfo);
        }
    };
    private static final Comparator<UsageInfo> BY_NAVIGATION_OFFSET = new Comparator<UsageInfo>(){

        @Override
        public int compare(UsageInfo o1, UsageInfo o2) {
            return o1.getNavigationOffset() - o2.getNavigationOffset();
        }
    };
    private final UsageInfo myUsageInfo;
    private Object myMergedUsageInfos;
    private final int myLineNumber;
    private final int myOffset;
    protected Icon myIcon;
    private volatile Reference<TextChunk[]> myTextChunks;
    private volatile UsageType myUsageType;
    private long myModificationStamp;

    public UsageInfo2UsageAdapter(final UsageInfo usageInfo) {
        this.myUsageInfo = usageInfo;
        this.myMergedUsageInfos = usageInfo;
        Point data = ApplicationManager.getApplication().runReadAction(new Computable<Point>(){

            public Point compute() {
                int lineNumber;
                int offset;
                Document document;
                PsiElement element = UsageInfo2UsageAdapter.this.getElement();
                PsiFile psiFile = usageInfo.getFile();
                Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance(UsageInfo2UsageAdapter.this.getProject()).getDocument(psiFile);
                if (document == null) {
                    offset = element == null ? 0 : element.getTextOffset();
                    lineNumber = -1;
                } else {
                    int startOffset = UsageInfo2UsageAdapter.this.myUsageInfo.getNavigationOffset();
                    if (startOffset == -1) {
                        offset = element == null ? 0 : element.getTextOffset();
                        lineNumber = -1;
                    } else {
                        offset = -1;
                        lineNumber = UsageInfo2UsageAdapter.getLineNumber(document, startOffset);
                    }
                }
                return new Point(offset, lineNumber);
            }
        });
        this.myOffset = data.x;
        this.myLineNumber = data.y;
        this.myModificationStamp = this.getCurrentModificationStamp();
    }

    private static int getLineNumber(Document document, int startOffset) {
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (startOffset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(startOffset);
    }

    private TextChunk[] initChunks() {
        PsiElement element;
        Document document;
        PsiFile psiFile = this.getPsiFile();
        Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile);
        TextChunk[] chunks = document == null ? ((element = this.getElement()) == null ? new TextChunk[]{new TextChunk(SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes(), UsageViewBundle.message("node.invalid", new Object[0]))} : new TextChunk[]{new TextChunk(new TextAttributes(), element.getText())}) : ChunkExtractor.extractChunks(psiFile, this);
        this.myTextChunks = new SoftReference((Object)chunks);
        return chunks;
    }

    @Override
    public UsagePresentation getPresentation() {
        return this;
    }

    @Override
    public boolean isValid() {
        PsiElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        for (UsageInfo usageInfo : this.getMergedInfos()) {
            if (usageInfo.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        PsiFile psiFile = this.getPsiFile();
        return psiFile == null || psiFile.isValid() && !psiFile.isWritable();
    }

    @Override
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance(this.getProject()).getSelectedEditor(virtualFile);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.getUsageInfo().getSegment();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    @Override
    public void selectInEditor() {
        if (!this.isValid()) {
            return;
        }
        Editor editor = this.openTextEditor(true);
        Segment marker = this.getFirstSegment();
        editor.getSelectionModel().setSelection(marker.getStartOffset(), marker.getEndOffset());
    }

    @Override
    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        Segment marker = this.getFirstSegment();
        SelectInEditorManager.getInstance(this.getProject()).selectInEditor(this.getFile(), marker.getStartOffset(), marker.getEndOffset(), false, false);
    }

    private Segment getFirstSegment() {
        return this.getUsageInfo().getSegment();
    }

    public boolean processRangeMarkers(Processor<Segment> processor) {
        for (UsageInfo usageInfo : this.getMergedInfos()) {
            Segment segment = usageInfo.getSegment();
            if (segment == null || processor.process((Object)segment)) continue;
            return false;
        }
        return true;
    }

    public Document getDocument() {
        PsiFile file = this.getUsageInfo().getFile();
        if (file == null) {
            return null;
        }
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file);
    }

    @Override
    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            this.openTextEditor(focus);
        }
    }

    public Editor openTextEditor(boolean focus) {
        return FileEditorManager.getInstance(this.getProject()).openTextEditor(this.getDescriptor(), focus);
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file = this.getFile();
        return file != null && file.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private OpenFileDescriptor getDescriptor() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        Segment range = this.getNavigationRange();
        if (range != null && file instanceof VirtualFileWindow && range.getStartOffset() >= 0) {
            range = ((VirtualFileWindow)((Object)file)).getDocumentWindow().injectedToHost(TextRange.create((Segment)range));
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        return new OpenFileDescriptor(this.getProject(), file, range == null ? this.getNavigationOffset() : range.getStartOffset());
    }

    int getNavigationOffset() {
        Document document = this.getDocument();
        if (document == null) {
            return -1;
        }
        int offset = this.getUsageInfo().getNavigationOffset();
        if (offset == -1) {
            offset = this.myOffset;
        }
        if (offset >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            offset = document.getLineStartOffset(line);
        }
        return offset;
    }

    private Segment getNavigationRange() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        Segment range = this.getUsageInfo().getNavigationRange();
        if (range == null) {
            ProperTextRange rangeInElement = this.getUsageInfo().getRangeInElement();
            Object object = this.myOffset < 0 ? new UnfairTextRange(-1, -1) : (range = rangeInElement == null ? TextRange.from((int)this.myOffset, (int)1) : rangeInElement.shiftRight(this.myOffset));
        }
        if (range.getEndOffset() >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            range = TextRange.from((int)document.getLineStartOffset(line), (int)1);
        }
        return range;
    }

    private Project getProject() {
        return this.getUsageInfo().getProject();
    }

    public String toString() {
        TextChunk[] textChunks = this.getPresentation().getText();
        StringBuilder result = new StringBuilder();
        for (int j = 0; j < textChunks.length; ++j) {
            if (j > 0) {
                result.append("|");
            }
            TextChunk textChunk = textChunks[j];
            result.append(textChunk);
        }
        return result.toString();
    }

    @Override
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(this.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        return fileIndex.getModuleForFile(virtualFile);
    }

    @Override
    public OrderEntry getLibraryEntry() {
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getPsiFile();
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(this.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        if (psiFile instanceof PsiCompiledElement || fileIndex.isInLibrarySource(virtualFile)) {
            List<OrderEntry> orders = fileIndex.getOrderEntriesForFile(virtualFile);
            for (OrderEntry order : orders) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return order;
            }
        }
        return null;
    }

    @Override
    public VirtualFile getFile() {
        return this.getUsageInfo().getVirtualFile();
    }

    private PsiFile getPsiFile() {
        return this.getUsageInfo().getFile();
    }

    public int getLine() {
        return this.myLineNumber;
    }

    @Override
    public boolean merge(MergeableUsage other) {
        if (!(other instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo2UsageAdapter u2 = (UsageInfo2UsageAdapter)other;
        assert (u2 != this);
        if (this.myLineNumber != u2.myLineNumber || !Comparing.equal((Object)this.getFile(), (Object)u2.getFile())) {
            return false;
        }
        UsageInfo[] merged = (UsageInfo[])ArrayUtil.mergeArrays((Object[])this.getMergedInfos(), (Object[])u2.getMergedInfos());
        this.myMergedUsageInfos = merged.length == 1 ? merged[0] : merged;
        Arrays.sort(this.getMergedInfos(), BY_NAVIGATION_OFFSET);
        this.myTextChunks = null;
        return true;
    }

    @Override
    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMergedUsageInfos = this.myUsageInfo;
        this.initChunks();
    }

    @Override
    public final PsiElement getElement() {
        return this.getUsageInfo().getElement();
    }

    public PsiReference getReference() {
        return this.getElement().getReference();
    }

    @Override
    public boolean isNonCodeUsage() {
        return this.getUsageInfo().isNonCodeUsage;
    }

    public UsageInfo getUsageInfo() {
        return this.myUsageInfo;
    }

    @Override
    public int compareTo(UsageInfo2UsageAdapter o) {
        VirtualFile containingFile = this.getFile();
        int shift1 = 0;
        if (containingFile instanceof VirtualFileWindow) {
            shift1 = ((VirtualFileWindow)((Object)containingFile)).getDocumentWindow().injectedToHost(0);
            containingFile = ((VirtualFileWindow)((Object)containingFile)).getDelegate();
        }
        VirtualFile oContainingFile = o.getFile();
        int shift2 = 0;
        if (oContainingFile instanceof VirtualFileWindow) {
            shift2 = ((VirtualFileWindow)((Object)oContainingFile)).getDocumentWindow().injectedToHost(0);
            oContainingFile = ((VirtualFileWindow)((Object)oContainingFile)).getDelegate();
        }
        if (containingFile == null && oContainingFile == null || !Comparing.equal((Object)containingFile, (Object)oContainingFile)) {
            return 0;
        }
        Segment s1 = this.getFirstSegment();
        Segment s2 = o.getFirstSegment();
        if (s1 == null || s2 == null) {
            return 0;
        }
        return s1.getStartOffset() + shift1 - s2.getStartOffset() - shift2;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void rename(String newName) throws IncorrectOperationException {
        PsiReference reference = this.getUsageInfo().getReference();
        assert (reference != null) : this;
        reference.handleElementRename(newName);
    }

    public static UsageInfo2UsageAdapter[] convert(UsageInfo[] usageInfos) {
        UsageInfo2UsageAdapter[] result = new UsageInfo2UsageAdapter[usageInfos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new UsageInfo2UsageAdapter(usageInfos[i]);
        }
        return result;
    }

    @Override
    public void calcData(DataKey key, DataSink sink) {
        if (key == UsageView.USAGE_INFO_KEY) {
            sink.put(UsageView.USAGE_INFO_KEY, this.getUsageInfo());
        }
        if (key == UsageView.USAGE_INFO_LIST_KEY) {
            List<UsageInfo> list = Arrays.asList(this.getMergedInfos());
            sink.put(UsageView.USAGE_INFO_LIST_KEY, list);
        }
    }

    private UsageInfo[] getMergedInfos() {
        UsageInfo[] usageInfoArray;
        Object infos = this.myMergedUsageInfos;
        if (infos instanceof UsageInfo) {
            UsageInfo[] usageInfoArray2 = new UsageInfo[1];
            usageInfoArray = usageInfoArray2;
            usageInfoArray2[0] = (UsageInfo)infos;
        } else {
            usageInfoArray = (UsageInfo[])infos;
        }
        return usageInfoArray;
    }

    private long getCurrentModificationStamp() {
        PsiFile containingFile = this.getPsiFile();
        return containingFile == null ? -1L : containingFile.getViewProvider().getModificationStamp();
    }

    @Override
    public TextChunk[] getText() {
        boolean isModified;
        TextChunk[] chunks = (TextChunk[])SoftReference.dereference(this.myTextChunks);
        long currentModificationStamp = this.getCurrentModificationStamp();
        boolean bl = isModified = currentModificationStamp != this.myModificationStamp;
        if (chunks == null || this.isValid() && isModified) {
            chunks = this.initChunks();
            this.myModificationStamp = currentModificationStamp;
        }
        return chunks;
    }

    @Override
    public String getPlainText() {
        Document document;
        int startOffset = this.getNavigationOffset();
        PsiElement element = this.getElement();
        if (element != null && startOffset != -1 && (document = this.getDocument()) != null) {
            int lineNumber = document.getLineNumber(startOffset);
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String prefixSuffix = null;
            if (lineEnd - lineStart > 200) {
                prefixSuffix = "...";
                lineStart = Math.max(startOffset - 1, lineStart);
                lineEnd = Math.min(startOffset + 1, lineEnd);
            }
            String s = ((Object)document.getCharsSequence().subSequence(lineStart, lineEnd)).toString();
            if (prefixSuffix != null) {
                s = prefixSuffix + s + prefixSuffix;
            }
            return s;
        }
        return UsageViewBundle.message("node.invalid", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            PsiElement psiElement = this.getElement();
            icon = psiElement != null && psiElement.isValid() && !this.isFindInPathUsage(psiElement) ? psiElement.getIcon(0) : null;
            this.myIcon = icon;
        }
        return icon;
    }

    private boolean isFindInPathUsage(PsiElement psiElement) {
        return psiElement instanceof PsiFile && this.getUsageInfo().getPsiFileRange() != null;
    }

    @Override
    public String getTooltipText() {
        return this.myUsageInfo.getTooltipText();
    }

    public UsageType getUsageType() {
        UsageType usageType = this.myUsageType;
        if (usageType == null) {
            usageType = UsageType.UNCLASSIFIED;
            PsiFile file = this.getPsiFile();
            if (file != null) {
                Document document;
                ChunkExtractor extractor = ChunkExtractor.getExtractor(file);
                Segment segment = this.getFirstSegment();
                if (segment != null && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument(file)) != null) {
                    SmartList chunks = new SmartList();
                    extractor.createTextChunks(this, document.getCharsSequence(), segment.getStartOffset(), segment.getEndOffset(), false, (List<TextChunk>)chunks);
                    for (TextChunk chunk : chunks) {
                        UsageType chunkUsageType = chunk.getType();
                        if (chunkUsageType == null) continue;
                        usageType = chunkUsageType;
                        break;
                    }
                }
            }
            this.myUsageType = usageType;
        }
        return usageType;
    }
}

