/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    public static Usage convert(TargetElementsDescriptor descriptor, UsageInfo usageInfo) {
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        return UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
    }

    public static Usage convert(PsiElement[] primaryElements, UsageInfo usageInfo) {
        PsiElement usageElement = usageInfo.getElement();
        for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions(ReadWriteAccessDetector.EP_NAME)) {
            if (!UsageInfoToUsageConverter.isReadWriteAccessibleElements(primaryElements, detector)) continue;
            ReadWriteAccessDetector.Access rwAccess = detector.getExpressionAccess(usageElement);
            return new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
        }
        return new UsageInfo2UsageAdapter(usageInfo);
    }

    public static Usage[] convert(TargetElementsDescriptor descriptor, UsageInfo[] usageInfos) {
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        return usages;
    }

    public static Usage[] convert(final PsiElement[] primaryElements, UsageInfo[] usageInfos) {
        Usage[] usages = (Usage[])ContainerUtil.map((Object[])usageInfos, (Function)new Function<UsageInfo, Usage>(){

            public Usage fun(UsageInfo info) {
                return UsageInfoToUsageConverter.convert(primaryElements, info);
            }
        }, (Object[])new Usage[usageInfos.length]);
        return usages;
    }

    private static boolean isReadWriteAccessibleElements(PsiElement[] elements, ReadWriteAccessDetector detector) {
        if (elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;
        private static final Function<SmartPsiElementPointer<PsiElement>, PsiElement> SMARTPOINTER_TO_ELEMENT_MAPPER = new Function<SmartPsiElementPointer<PsiElement>, PsiElement>(){

            public PsiElement fun(SmartPsiElementPointer<PsiElement> pointer) {
                return pointer.getElement();
            }
        };

        public TargetElementsDescriptor(PsiElement element) {
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements) {
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements, PsiElement[] additionalSearchedElements) {
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        private static PsiElement[] convertToPsiElements(List<SmartPsiElementPointer<PsiElement>> primary) {
            return (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SMARTPOINTER_TO_ELEMENT_MAPPER), PsiElement.ARRAY_FACTORY);
        }

        private static List<SmartPsiElementPointer<PsiElement>> convertToSmartPointers(PsiElement[] primaryElements) {
            if (primaryElements.length == 0) {
                return Collections.emptyList();
            }
            final SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(primaryElements[0].getProject());
            return ContainerUtil.mapNotNull((Object[])primaryElements, (Function)new Function<PsiElement, SmartPsiElementPointer<PsiElement>>(){

                public SmartPsiElementPointer<PsiElement> fun(PsiElement s) {
                    return smartPointerManager.createSmartPsiElementPointer(s);
                }
            });
        }

        public PsiElement[] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        public PsiElement[] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            return result;
        }

        public List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            ArrayList<SmartPsiElementPointer<PsiElement>> result = new ArrayList<SmartPsiElementPointer<PsiElement>>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            result.addAll(this.myPrimarySearchedElements);
            result.addAll(this.myAdditionalSearchedElements);
            return result;
        }
    }
}

