/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final Object lock = new Object();
    private final UsageGroup myGroup;
    private final int myRuleIndex;
    private final Map<UsageGroup, GroupNode> mySubgroupNodes = new THashMap();
    private final List<UsageNode> myUsageNodes = new SmartList();
    private final UsageViewTreeModelBuilder myUsageTreeModel;
    private volatile int myRecursiveUsageCount = 0;

    public GroupNode(UsageGroup group, int ruleIndex, UsageViewTreeModelBuilder treeModel) {
        super(treeModel);
        this.myUsageTreeModel = treeModel;
        this.setUserObject(group);
        this.myGroup = group;
        this.myRuleIndex = ruleIndex;
    }

    @Override
    protected void updateNotify() {
        if (this.myGroup != null) {
            this.myGroup.update();
        }
    }

    @Override
    public String toString() {
        String result = "";
        if (this.myGroup != null) {
            result = this.myGroup.getText(null);
        }
        if (this.children == null) {
            return result;
        }
        return result + this.children.subList(0, Math.min(10, this.children.size())).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNode addGroup(UsageGroup group, int ruleIndex, Consumer<Runnable> edtQueue) {
        Object object = this.lock;
        synchronized (object) {
            GroupNode node = this.mySubgroupNodes.get(group);
            if (node == null) {
                GroupNode node1 = node = new GroupNode(group, ruleIndex, this.getBuilder());
                this.mySubgroupNodes.put(group, node);
                this.addNode(node1, edtQueue);
            }
            return node;
        }
    }

    void addNode(final DefaultMutableTreeNode node, Consumer<Runnable> edtQueue) {
        if (!this.getBuilder().isDetachedMode()) {
            edtQueue.consume((Object)new Runnable(){

                @Override
                public void run() {
                    GroupNode.this.myTreeModel.insertNodeInto(node, GroupNode.this, GroupNode.this.getNodeInsertionIndex(node));
                }
            });
        }
    }

    private UsageViewTreeModelBuilder getBuilder() {
        return (UsageViewTreeModelBuilder)this.myTreeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        Object object = this.lock;
        synchronized (object) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            super.removeAllChildren();
            this.mySubgroupNodes.clear();
            this.myRecursiveUsageCount = 0;
            this.myUsageNodes.clear();
        }
        this.myTreeModel.reload(this);
    }

    UsageNode tryMerge(Usage usage) {
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.myUsageNodes) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUsage(UsageNode usage) {
        boolean removed;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Collection<GroupNode> groupNodes = this.mySubgroupNodes.values();
        Iterator<GroupNode> iterator = groupNodes.iterator();
        while (iterator.hasNext()) {
            GroupNode groupNode = iterator.next();
            if (!groupNode.removeUsage(usage)) continue;
            this.doUpdate();
            if (groupNode.getRecursiveUsageCount() == 0) {
                this.myTreeModel.removeNodeFromParent(groupNode);
                iterator.remove();
            }
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            removed = this.myUsageNodes.remove(usage);
        }
        if (removed) {
            this.doUpdate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUsagesBulk(Set<UsageNode> usages) {
        boolean removed;
        Object object = this.lock;
        synchronized (object) {
            removed = this.myUsageNodes.removeAll(usages);
        }
        Collection<GroupNode> groupNodes = this.mySubgroupNodes.values();
        Iterator<GroupNode> iterator = groupNodes.iterator();
        while (iterator.hasNext()) {
            GroupNode groupNode = iterator.next();
            if (!groupNode.removeUsagesBulk(usages)) continue;
            if (groupNode.getRecursiveUsageCount() == 0) {
                MutableTreeNode parent = (MutableTreeNode)groupNode.getParent();
                int childIndex = parent.getIndex(groupNode);
                if (childIndex != -1) {
                    parent.remove(childIndex);
                }
                iterator.remove();
            }
            removed = true;
        }
        if (removed) {
            --this.myRecursiveUsageCount;
        }
        return removed;
    }

    private void doUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        --this.myRecursiveUsageCount;
        this.myTreeModel.nodeChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageNode addUsage(Usage usage, Consumer<Runnable> edtQueue) {
        UsageNode node;
        Object object = this.lock;
        synchronized (object) {
            UsageNode mergedWith;
            if (this.myUsageTreeModel.isFilterDuplicatedLine() && (mergedWith = this.tryMerge(usage)) != null) {
                return mergedWith;
            }
            node = new UsageNode(usage, this.getBuilder());
            this.myUsageNodes.add(node);
        }
        if (!this.getBuilder().isDetachedMode()) {
            edtQueue.consume((Object)new Runnable(){

                @Override
                public void run() {
                    GroupNode.this.myTreeModel.insertNodeInto(node, GroupNode.this, GroupNode.this.getNodeIndex(node));
                    GroupNode.this.incrementUsageCount();
                }
            });
        }
        return node;
    }

    private int getNodeIndex(UsageNode node) {
        int index = this.indexedBinarySearch(node);
        return index >= 0 ? index : -index - 1;
    }

    private int indexedBinarySearch(UsageNode key) {
        int low = 0;
        int high = this.getChildCount() - 1;
        while (low <= high) {
            int cmp;
            int mid = (low + high) / 2;
            TreeNode treeNode = this.getChildAt(mid);
            if (treeNode instanceof UsageNode) {
                UsageNode midVal = (UsageNode)treeNode;
                cmp = midVal.compareTo(key);
            } else {
                cmp = -1;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void incrementUsageCount() {
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            GroupNode node = groupNode;
            this.myTreeModel.nodeChanged(node);
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        if (this.myGroup != null) {
            result.append(this.myGroup.toString());
        }
        result.append("[");
        result.append(lineSeparator);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            result.append(node.tree2string(indent + 4, lineSeparator));
            result.append(lineSeparator);
        }
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append("]");
        result.append(lineSeparator);
        return result.toString();
    }

    @Override
    protected boolean isDataValid() {
        return this.myGroup == null || this.myGroup.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    private int getNodeInsertionIndex(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child;
        Enumeration<TreeNode> children = this.children();
        int idx = 0;
        while (children.hasMoreElements() && COMPARATOR.compare(child = (DefaultMutableTreeNode)children.nextElement(), node) < 0) {
            ++idx;
        }
        return idx;
    }

    @Override
    public int compareTo(GroupNode groupNode) {
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.myGroup.compareTo(groupNode.myGroup);
        }
        return this.myRuleIndex - groupNode.myRuleIndex;
    }

    public UsageGroup getGroup() {
        return this.myGroup;
    }

    public int getRecursiveUsageCount() {
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.myGroup != null) {
            this.myGroup.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.myGroup != null && this.myGroup.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myGroup != null && this.myGroup.canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getText(UsageView view) {
        return this.myGroup.getText(view);
    }

    public Collection<GroupNode> getSubGroups() {
        return this.mySubgroupNodes.values();
    }

    public Collection<UsageNode> getUsageNodes() {
        return this.myUsageNodes;
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static int getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return 3;
            }
            if (node instanceof GroupNode) {
                return 2;
            }
            if (node instanceof UsageTargetNode) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            int classIdx2;
            int classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1 - classIdx2;
            }
            if (classIdx1 == 2) {
                return ((GroupNode)n1).compareTo((GroupNode)n2);
            }
            return 0;
        }
    }
}

