/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import java.util.Arrays;

public class UsageNode
extends Node
implements Comparable<UsageNode>,
Navigatable {
    private final Usage myUsage;
    private boolean myUsageExcluded = false;

    public UsageNode(Usage usage, UsageViewTreeModelBuilder model) {
        super(model);
        this.setUserObject(usage);
        this.myUsage = usage;
    }

    @Override
    public String toString() {
        return this.myUsage.toString();
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append(this.myUsage.toString());
        return result.toString();
    }

    @Override
    public int compareTo(UsageNode usageNode) {
        return UsageViewImpl.USAGE_COMPARATOR.compare(this.myUsage, usageNode.getUsage());
    }

    public Usage getUsage() {
        return this.myUsage;
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.myUsage.navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.myUsage.isValid() && this.myUsage.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myUsage.isValid() && this.myUsage.canNavigate();
    }

    @Override
    protected boolean isDataValid() {
        return this.myUsage.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        return this.myUsage.isReadOnly();
    }

    @Override
    protected boolean isDataExcluded() {
        return this.myUsageExcluded;
    }

    @Override
    protected String getText(UsageView view) {
        try {
            return this.myUsage.getPresentation().getPlainText();
        }
        catch (AbstractMethodError e) {
            return Arrays.asList(this.myUsage.getPresentation().getText()).toString();
        }
    }

    public void setUsageExcluded(boolean usageExcluded) {
        this.myUsageExcluded = usageExcluded;
    }
}

