/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleEx;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.util.Consumer;

class UsageNodeTreeBuilder {
    private final GroupNode myRoot;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    UsageNodeTreeBuilder(UsageTarget[] targets, UsageGroupingRule[] groupingRules, UsageFilteringRule[] filteringRules, GroupNode root) {
        this.myTargets = targets;
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
    }

    public void setGroupingRules(UsageGroupingRule[] rules) {
        this.myGroupingRules = rules;
    }

    public void setFilteringRules(UsageFilteringRule[] rules) {
        this.myFilteringRules = rules;
    }

    public boolean isVisible(Usage usage) {
        for (UsageFilteringRule rule : this.myFilteringRules) {
            boolean visible = rule instanceof UsageFilteringRuleEx ? ((UsageFilteringRuleEx)rule).isVisible(usage, this.myTargets) : rule.isVisible(usage);
            if (visible) continue;
            return false;
        }
        return true;
    }

    UsageNode appendUsage(Usage usage, Consumer<Runnable> edtQueue) {
        if (!this.isVisible(usage)) {
            return null;
        }
        GroupNode lastGroupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroupingRule rule = this.myGroupingRules[i];
            UsageGroup group = rule instanceof UsageGroupingRuleEx ? ((UsageGroupingRuleEx)rule).groupUsage(usage, this.myTargets) : rule.groupUsage(usage);
            if (group == null) continue;
            lastGroupNode = lastGroupNode.addGroup(group, i, edtQueue);
        }
        return lastGroupNode.addUsage(usage, edtQueue);
    }
}

