/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.Alarm");
    private volatile boolean myDisposed;
    private final List<Request> myRequests = new SmartList();
    private final List<Request> myPendingRequests = new SmartList();
    private final ExecutorService myExecutorService;
    private static final ThreadPoolExecutor ourSharedExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"Alarm pool(shared)", (int)3);
    private final Object LOCK = new Object();
    protected final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        this.myDisposed = true;
        this.cancelAllRequests();
        if (this.myThreadToUse == ThreadToUse.POOLED_THREAD) {
            this.myExecutorService.shutdown();
        } else if (this.myThreadToUse == ThreadToUse.OWN_THREAD) {
            this.myExecutorService.shutdown();
            ((ThreadPoolExecutor)this.myExecutorService).getQueue().clear();
        }
    }

    public void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(Disposable parentDisposable) {
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(ThreadToUse threadToUse) {
        this(threadToUse, null);
        LOG.assertTrue(threadToUse != ThreadToUse.POOLED_THREAD && threadToUse != ThreadToUse.OWN_THREAD, (Object)"You must provide parent Disposable for ThreadToUse.POOLED_THREAD and ThreadToUse.OWN_THREAD Alarm");
    }

    public Alarm(ThreadToUse threadToUse, Disposable parentDisposable) {
        this.myThreadToUse = threadToUse;
        this.myExecutorService = threadToUse == ThreadToUse.POOLED_THREAD ? new MyExecutor() : (threadToUse == ThreadToUse.OWN_THREAD ? ConcurrencyUtil.newSingleThreadExecutor((String)"Alarm pool(own)", (int)3) : ourSharedExecutorService);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(final Runnable request, final int delay, boolean runWithActiveFrameOnly) {
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

                @Override
                public void applicationActivated(IdeFrame ideFrame) {
                    connection.disconnect();
                    Alarm.this.addRequest(request, delay);
                }
            });
        } else {
            this.addRequest(request, delay);
        }
    }

    public void addRequest(Runnable request, long delayMillis) {
        this._addRequest(request, delayMillis, this.myThreadToUse == ThreadToUse.SWING_THREAD ? ModalityState.current() : null);
    }

    public void addRequest(Runnable request, int delayMillis) {
        this._addRequest(request, delayMillis, this.myThreadToUse == ThreadToUse.SWING_THREAD ? ModalityState.current() : null);
    }

    public void addComponentRequest(Runnable request, int delay) {
        assert (this.myActivationComponent != null);
        this._addRequest(request, delay, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(Runnable request, long delayMillis) {
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(Runnable request, int delayMillis, ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    public void addRequest(Runnable request, long delayMillis, ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addRequest(Runnable request, long delayMillis, ModalityState modalityState) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkDisposed();
            Request requestToSchedule = new Request(request, modalityState, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this._add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void _add(Request requestToSchedule) {
        ScheduledFuture<?> future = JobScheduler.getScheduler().schedule(requestToSchedule, requestToSchedule.myDelay, TimeUnit.MILLISECONDS);
        requestToSchedule.setFuture(future);
        this.myRequests.add(requestToSchedule);
    }

    private void flushPending() {
        for (Request each : this.myPendingRequests) {
            this._add(each);
        }
        this.myPendingRequests.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(Runnable request) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelRequest(request, this.myRequests);
            this.cancelRequest(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelRequest(Runnable request, List<Request> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.getTask() != request) continue;
            r.cancel();
            list.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.cancelAllRequests(this.myRequests);
            this.cancelAllRequests(this.myPendingRequests);
            return count;
        }
    }

    private int cancelAllRequests(List<Request> list) {
        int count = 0;
        for (Request request : list) {
            ++count;
            request.cancel();
        }
        list.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        SmartList requests;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myRequests.isEmpty()) {
                return;
            }
            requests = new SmartList();
            for (Request request : this.myRequests) {
                Runnable existingTask = request.cancel();
                if (existingTask == null) continue;
                requests.add(Pair.create((Object)request, (Object)existingTask));
            }
            this.myRequests.clear();
        }
        for (Pair request : requests) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                ((Request)request.first).myTask = (Runnable)request.second;
            }
            ((Request)request.first).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public static boolean isEventDispatchThread() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isDispatchThread() || EventQueue.isDispatchThread();
    }

    public Alarm setActivationComponent(JComponent component) {
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }

            @Override
            public void hideNotify() {
            }
        });
        return this;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private class MyExecutor
    extends AbstractExecutorService {
        private final AtomicBoolean isShuttingDown = new AtomicBoolean();
        private final QueueProcessor<Runnable> myProcessor = QueueProcessor.createRunnableQueueProcessor();

        private MyExecutor() {
        }

        @Override
        public void shutdown() {
            this.myProcessor.clear();
            this.isShuttingDown.set(Alarm.this.myDisposed);
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return this.isShuttingDown.get();
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown() && this.myProcessor.isEmpty();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            this.myProcessor.add(command);
        }
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelay;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request(Runnable task, ModalityState modalityState, long delayMillis) {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task;
                this.myModalityState = modalityState;
                this.myDelay = delayMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    if (Alarm.this.myDisposed) {
                        return;
                    }
                    Object object = Alarm.this.LOCK;
                    synchronized (object) {
                        if (this.myTask == null) {
                            return;
                        }
                    }
                    Runnable scheduledTask = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Runnable task;
                            Object object = Alarm.this.LOCK;
                            synchronized (object) {
                                task = Request.this.myTask;
                                if (task == null) {
                                    return;
                                }
                                Request.this.myTask = null;
                                Alarm.this.myRequests.remove(Request.this);
                                Request.this.myFuture = null;
                            }
                            if (Alarm.this.myThreadToUse == ThreadToUse.SWING_THREAD && !Alarm.this.isEdt()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!Alarm.this.myDisposed) {
                                            QueueProcessor.runSafely(task);
                                        }
                                    }
                                });
                            } else {
                                QueueProcessor.runSafely(task);
                            }
                        }

                        public String toString() {
                            return "ScheduledTask " + Request.this;
                        }
                    };
                    if (this.myModalityState == null) {
                        Future<?> future = Alarm.this.myExecutorService.submit(scheduledTask);
                        Object object2 = Alarm.this.LOCK;
                        synchronized (object2) {
                            this.myFuture = future;
                            break block15;
                        }
                    }
                    Application app = ApplicationManager.getApplication();
                    if (app == null) {
                        SwingUtilities.invokeLater(scheduledTask);
                    } else if (app.isDispatchThread() && app.getCurrentModalityState().equals(this.myModalityState)) {
                        scheduledTask.run();
                    } else {
                        app.invokeLater(scheduledTask, this.myModalityState);
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable getTask() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                return this.myTask;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFuture(ScheduledFuture<?> future) {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myFuture = future;
            }
        }

        public ModalityState getModalityState() {
            return this.myModalityState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable cancel() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                if (this.myFuture != null) {
                    this.myFuture.cancel(false);
                    ((ScheduledThreadPoolExecutor)JobScheduler.getScheduler()).remove((Runnable)((Object)this.myFuture));
                    this.myFuture = null;
                }
                Runnable task = this.myTask;
                this.myTask = null;
                return task;
            }
        }

        public String toString() {
            Runnable task = this.getTask();
            return super.toString() + (task != null ? ": " + task : "");
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD,
        OWN_THREAD;

    }
}

