/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ExecutorsQuery");
    private final List<QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(Parameter params, List<QueryExecutor<Result, Parameter>> executors) {
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(Processor<Result> consumer) {
        for (QueryExecutor<Result, Parameter> executor : this.myExecutors) {
            try {
                if (executor.execute(this.myParameters, consumer)) continue;
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }
}

