/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create((String)"iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = new NullableFunction<FileIconKey, Icon>(){

        public Icon fun(FileIconKey key) {
            VirtualFile file = key.getFile();
            int flags = key.getFlags();
            Project project = key.getProject();
            if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
                return null;
            }
            Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
            Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file) : providersIcon;
            boolean dumb = project != null && DumbService.getInstance(project).isDumb();
            for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                if (dumb && !DumbService.isDumbAware(patcher)) continue;
                icon = patcher.patchIcon(icon, file, flags, project);
            }
            if (!((flags & 2) == 0 || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
                icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
            }
            if (file.is(VFileProperty.SYMLINK)) {
                icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
            }
            Iconable.LastComputedIcon.put((UserDataHolder)file, icon, flags);
            return icon;
        }
    };

    private static boolean wasEverInitialized(Project project) {
        Boolean was = (Boolean)project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    public static Icon cropIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            return icon;
        }
        int w = Math.min(icon.getIconWidth(), maxWidth);
        int h = Math.min(icon.getIconHeight(), maxHeight);
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        g.dispose();
        BufferedImage img = UIUtil.createImage((int)w, (int)h, (int)3);
        int offX = icon.getIconWidth() > maxWidth ? (icon.getIconWidth() - maxWidth) / 2 : 0;
        int offY = icon.getIconHeight() > maxHeight ? (icon.getIconHeight() - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, image.getRGB(col + offX, row + offY));
            }
        }
        return new ImageIcon(img);
    }

    public static Icon cropIcon(Icon icon, Rectangle area) {
        if (!new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area)) {
            return icon;
        }
        return new CropIcon(icon, area);
    }

    public static Icon flip(Icon icon, boolean horizontal) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage first = UIUtil.createImage((int)w, (int)h, (int)2);
        Graphics2D g = first.createGraphics();
        icon.paintIcon(new JPanel(), g, 0, 0);
        g.dispose();
        BufferedImage second = UIUtil.createImage((int)w, (int)h, (int)2);
        g = second.createGraphics();
        if (horizontal) {
            g.drawImage(first, 0, 0, w, h, w, 0, 0, h, null);
        } else {
            g.drawImage(first, 0, 0, w, h, 0, h, w, 0, null);
        }
        g.dispose();
        return new ImageIcon(second);
    }

    public static Icon getIcon(VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        Icon lastIcon = Iconable.LastComputedIcon.get((UserDataHolder)file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIconImpl(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    private static Icon getProvidersIcon(VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        return baseIcon;
    }

    private static Icon createEmptyIconLike(String baseIconPath) {
        Icon baseIcon = IconLoader.findIcon((String)baseIconPath);
        if (baseIcon == null) {
            return EmptyIcon.ICON_16;
        }
        return new EmptyIcon(baseIcon.getIconWidth(), baseIcon.getIconHeight());
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Image toImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static Icon getAddIcon() {
        return IconUtil.getToolbarDecoratorIcon("add.png");
    }

    public static Icon getRemoveIcon() {
        return IconUtil.getToolbarDecoratorIcon("remove.png");
    }

    public static Icon getMoveUpIcon() {
        return IconUtil.getToolbarDecoratorIcon("moveUp.png");
    }

    public static Icon getMoveDownIcon() {
        return IconUtil.getToolbarDecoratorIcon("moveDown.png");
    }

    public static Icon getEditIcon() {
        return IconUtil.getToolbarDecoratorIcon("edit.png");
    }

    public static Icon getAddClassIcon() {
        return IconUtil.getToolbarDecoratorIcon("addClass.png");
    }

    public static Icon getAddPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addPattern.png");
    }

    public static Icon getAddJiraPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addJira.png");
    }

    public static Icon getAddYouTrackPatternIcon() {
        return IconUtil.getToolbarDecoratorIcon("addYouTrack.png");
    }

    public static Icon getAddBlankLineIcon() {
        return IconUtil.getToolbarDecoratorIcon("addBlankLine.png");
    }

    public static Icon getAddPackageIcon() {
        return IconUtil.getToolbarDecoratorIcon("addPackage.png");
    }

    public static Icon getAddLinkIcon() {
        return IconUtil.getToolbarDecoratorIcon("addLink.png");
    }

    public static Icon getAddFolderIcon() {
        return IconUtil.getToolbarDecoratorIcon("addFolder.png");
    }

    public static Icon getAnalyzeIcon() {
        return IconUtil.getToolbarDecoratorIcon("analyze.png");
    }

    public static void paintInCenterOf(Component c, Graphics g, Icon icon) {
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    public static Icon getToolbarDecoratorIcon(String name) {
        return IconLoader.getIcon((String)(IconUtil.getToolbarDecoratorIconsFolder() + name));
    }

    private static String getToolbarDecoratorIconsFolder() {
        return "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
    }

    public static Icon[] getEqualSizedIcons(Icon ... icons) {
        Icon[] result = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon : icons) {
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        for (int i = 0; i < icons.length; ++i) {
            result[i] = new IconSizeWrapper(icons[i], width, height);
        }
        return result;
    }

    public static Icon toSize(Icon icon, int width, int height) {
        return new IconSizeWrapper(icon, width, height);
    }

    public static Icon scale(final Icon source, double _scale) {
        Image image;
        final int hiDPIscale = source instanceof ImageIcon ? (RetinaImage.isAppleHiDPIScaledImage((Image)(image = ((ImageIcon)source).getImage())) || image instanceof JBHiDPIScaledImage ? 2 : 1) : 1;
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, x, y);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale) / hiDPIscale;
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale) / hiDPIscale;
            }
        };
    }

    public static Icon colorize(Icon source, Color color) {
        return IconUtil.colorize(source, color, false);
    }

    public static Icon colorize(Icon source, Color color, boolean keepGray) {
        float[] base = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        BufferedImage image = UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        Graphics2D g = image.createGraphics();
        source.paintIcon(null, g, 0, 0);
        g.dispose();
        BufferedImage img = UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        int[] rgba = new int[4];
        float[] hsb = new float[3];
        for (int y = 0; y < image.getRaster().getHeight(); ++y) {
            for (int x = 0; x < image.getRaster().getWidth(); ++x) {
                image.getRaster().getPixel(x, y, rgba);
                if (rgba[3] == 0) continue;
                Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], hsb);
                int rgb = Color.HSBtoRGB(base[0], base[1] * (keepGray ? hsb[1] : 1.0f), base[2] * hsb[2]);
                img.getRaster().setPixel(x, y, new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgba[3]});
            }
        }
        return new JBImageIcon(img){

            public int getIconWidth() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconWidth() / 2 : super.getIconWidth();
            }

            public int getIconHeight() {
                return this.getImage() instanceof JBHiDPIScaledImage ? super.getIconHeight() / 2 : super.getIconHeight();
            }
        };
    }

    private static class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(Icon src, Rectangle crop) {
            this.mySrc = src;
            this.myCrop = crop;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }
    }

    private static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        private IconSizeWrapper(Icon icon, int width, int height) {
            this.myIcon = icon;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x += (this.myWidth - this.myIcon.getIconWidth()) / 2, y += (this.myHeight - this.myIcon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = (FileIconPatcher[])Extensions.getExtensions(FileIconPatcher.EP_NAME);

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = (FileIconProvider[])Extensions.getExtensions(FileIconProvider.EP_NAME);

        private FileIconProviderHolder() {
        }
    }
}

