/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class PathUtil {
    private PathUtil() {
    }

    public static String getLocalPath(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    public static String getLocalPath(String path) {
        return FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)path, (String)"!/"));
    }

    public static VirtualFile getLocalFile(VirtualFile file) {
        VirtualFile localFile;
        if (!file.isValid()) {
            return file;
        }
        if (file.getFileSystem() instanceof LocalFileProvider && (localFile = ((LocalFileProvider)((Object)file.getFileSystem())).getLocalVirtualFileFor(file)) != null) {
            return localFile;
        }
        return file;
    }

    public static String getJarPathForClass(Class aClass) {
        String pathForClass = PathManager.getJarPathForClass((Class)aClass);
        assert (pathForClass != null) : aClass;
        return pathForClass;
    }

    public static String toPresentableUrl(String url) {
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    public static String getCanonicalPath(@NonNls String path) {
        return FileUtil.toCanonicalPath((String)path);
    }

    public static String getFileName(String path) {
        return PathUtilRt.getFileName((String)path);
    }

    public static String getFileExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static String getParentPath(String path) {
        return PathUtilRt.getParentPath((String)path);
    }

    public static String suggestFileName(String text) {
        return PathUtilRt.suggestFileName((String)text);
    }

    public static String suggestFileName(String text, boolean allowDots, boolean allowSpaces) {
        return PathUtilRt.suggestFileName((String)text, (boolean)allowDots, (boolean)allowSpaces);
    }

    public static boolean isValidFileName(String fileName) {
        return PathUtilRt.isValidFileName((String)fileName);
    }

    public static String toSystemIndependentName(String path) {
        return path == null ? null : FileUtilRt.toSystemIndependentName((String)path);
    }

    public static String toSystemDependentName(String path) {
        return path == null ? null : FileUtilRt.toSystemDependentName((String)path);
    }

    public static String driveLetterToLowerCase(String path) {
        if (!SystemInfo.isWindows) {
            return path;
        }
        File file = new File(path);
        if (file.isAbsolute() && path.length() >= 2 && Character.isUpperCase(path.charAt(0)) && path.charAt(1) == ':') {
            return Character.toLowerCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    public static String makeFileName(String name, String extension) {
        return name + (StringUtil.isEmpty((String)extension) ? "" : "." + extension);
    }
}

