/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayDeque;

public class ProducerConsumer<T> {
    public static final int ourDefaultMaxSize = 20;
    private final ArrayDeque<T> myQueue;
    private final Consumer<T> myConsumer;
    private final int myMaxSize;
    private final Object myLock;
    private final ConsumerRunnable myConsumerThread;
    private boolean myIsAlive;

    public ProducerConsumer(Consumer<T> consumer) {
        this(consumer, 20);
    }

    public void start() {
        this.myIsAlive = true;
        this.myConsumerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIsAlive = false;
            this.myLock.notifyAll();
        }
    }

    public ProducerConsumer(Consumer<T> consumer, int maxSize) {
        this(consumer, maxSize, false);
    }

    public ProducerConsumer(Consumer<T> consumer, int maxSize, boolean onPooledThread) {
        this.myConsumer = consumer;
        this.myQueue = new ArrayDeque();
        this.myMaxSize = maxSize;
        this.myLock = new Object();
        if (onPooledThread) {
            this.myConsumerThread = new PooledConsumerRunnable();
            ApplicationManager.getApplication().executeOnPooledThread(this.myConsumerThread);
        } else {
            this.myConsumerThread = new ConsumerRunnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(T t) {
        Object object = this.myLock;
        synchronized (object) {
            while (this.myQueue.size() >= this.myMaxSize) {
                try {
                    this.myLock.notifyAll();
                    this.myLock.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myQueue.addLast(t);
            this.myLock.notifyAll();
        }
    }

    private class ConsumerRunnable
    implements Runnable {
        private Thread myThread;

        private ConsumerRunnable() {
        }

        public void start() {
            this.myThread.start();
        }

        public void setThread(Thread thread) {
            this.myThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.waitForStart();
            Object object = ProducerConsumer.this.myLock;
            synchronized (object) {
                while (ProducerConsumer.this.myIsAlive) {
                    if (!ProducerConsumer.this.myQueue.isEmpty()) {
                        ProducerConsumer.this.myConsumer.consume(ProducerConsumer.this.myQueue.removeFirst());
                        continue;
                    }
                    try {
                        ProducerConsumer.this.myLock.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void waitForStart() {
        }
    }

    private class PooledConsumerRunnable
    extends ConsumerRunnable {
        private final Semaphore mySemaphore = new Semaphore();

        private PooledConsumerRunnable() {
            this.mySemaphore.down();
        }

        @Override
        public void start() {
            this.mySemaphore.up();
        }

        @Override
        protected void waitForStart() {
            this.mySemaphore.waitFor();
        }
    }
}

