/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;

public class WorkerThread
implements Runnable,
Disposable {
    private final LinkedList<Runnable> myTasks = new LinkedList();
    private boolean myToDispose = false;
    private boolean myDisposed = false;
    private final int mySleep;
    private final String myName;

    public WorkerThread(@NonNls String name, int sleep) {
        this.mySleep = sleep;
        this.myName = name;
    }

    public void start() {
        ApplicationManager.getApplication().executeOnPooledThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(Runnable action) {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            if (this.myDisposed) {
                return false;
            }
            this.myTasks.add(action);
            this.myTasks.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTaskFirst(Runnable action) {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            if (this.myDisposed) {
                return false;
            }
            this.myTasks.add(0, action);
            this.myTasks.notifyAll();
            return true;
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean cancelTasks) {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            if (cancelTasks) {
                this.myTasks.clear();
            }
            this.myToDispose = true;
            this.myTasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTasks() {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            this.myTasks.clear();
            this.myTasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposeRequested() {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            return this.myToDispose;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        LinkedList<Runnable> linkedList = this.myTasks;
        synchronized (linkedList) {
            return this.myDisposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            block13: {
                Runnable task;
                LinkedList<Runnable> linkedList = this.myTasks;
                synchronized (linkedList) {
                    if (this.myTasks.isEmpty()) {
                        break block13;
                    }
                    task = this.myTasks.removeFirst();
                }
                task.run();
                try {
                    if (this.mySleep <= 0) continue;
                    Thread.sleep(this.mySleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            LinkedList<Runnable> linkedList = this.myTasks;
            synchronized (linkedList) {
                if (this.myToDispose && this.myTasks.isEmpty()) {
                    this.myDisposed = true;
                    return;
                }
                try {
                    this.myTasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

