/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;

public class ConfigFileMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.descriptors.ConfigFileMetaData");
    private final String myTitle;
    private final String myId;
    private final String myFileName;
    private final String myDirectoryPath;
    private final ConfigFileVersion[] myVersions;
    private final ConfigFileVersion myDefaultVersion;
    private final boolean myOptional;
    private final boolean myFileNameFixed;
    private final boolean myUnique;

    public ConfigFileMetaData(String title, @NonNls String id, @NonNls String fileName, @NonNls String directoryPath, ConfigFileVersion[] versions, ConfigFileVersion defaultVersion, boolean optional, boolean fileNameFixed, boolean unique) {
        this.myTitle = title;
        this.myId = id;
        this.myFileName = fileName;
        this.myDirectoryPath = directoryPath;
        this.myFileNameFixed = fileNameFixed;
        this.myUnique = unique;
        LOG.assertTrue(versions.length > 0);
        this.myVersions = versions;
        this.myOptional = optional;
        this.myDefaultVersion = defaultVersion != null ? defaultVersion : this.myVersions[this.myVersions.length - 1];
        LOG.assertTrue(Arrays.asList(this.myVersions).contains(this.myDefaultVersion));
    }

    public ConfigFileMetaData(String title, @NonNls String fileName, @NonNls String directoryPath, ConfigFileVersion[] versions, ConfigFileVersion defaultVersion, boolean optional, boolean fileNameFixed, boolean unique) {
        this(title, fileName, fileName, directoryPath, versions, defaultVersion, optional, fileNameFixed, unique);
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getId() {
        return this.myId;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public String getDirectoryPath() {
        return this.myDirectoryPath;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public ConfigFileVersion[] getVersions() {
        return this.myVersions;
    }

    public String toString() {
        return this.myTitle;
    }

    public ConfigFileVersion getDefaultVersion() {
        return this.myDefaultVersion;
    }

    public boolean isFileNameFixed() {
        return this.myFileNameFixed;
    }

    public boolean isUnique() {
        return this.myUnique;
    }
}

