/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public abstract class FileBasedIndex
implements BaseComponent {
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = SystemProperties.getBooleanProperty((String)"idea.enable.tracing.keyhash2virtualfile", (boolean)true);

    public abstract void iterateIndexableFiles(ContentIterator var1, Project var2, ProgressIndicator var3);

    public abstract void registerIndexableSet(IndexableFileSet var1, Project var2);

    public abstract void removeIndexableSet(IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return ApplicationManager.getApplication().getComponent(FileBasedIndex.class);
    }

    public static int getFileId(VirtualFile file) {
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(ID<?, ?> indexId) {
        this.requestRebuild(indexId, new Throwable());
    }

    @Override
    @NonNls
    public String getComponentName() {
        return "FileBasedIndex";
    }

    public abstract <K, V> List<V> getValues(ID<K, V> var1, K var2, GlobalSearchScope var3);

    public abstract <K, V> Collection<VirtualFile> getContainingFiles(ID<K, V> var1, K var2, GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(ID<K, V> var1, K var2, VirtualFile var3, ValueProcessor<V> var4, GlobalSearchScope var5);

    public <K, V> boolean processValues(ID<K, V> indexId, K dataKey, VirtualFile inFile, ValueProcessor<V> processor, GlobalSearchScope filter, IdFilter idFilter) {
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> boolean processFilesContainingAllKeys(ID<K, V> var1, Collection<K> var2, GlobalSearchScope var3, Condition<V> var4, Processor<VirtualFile> var5);

    public abstract <K> Collection<K> getAllKeys(ID<K, ?> var1, Project var2);

    public abstract <K> void ensureUpToDate(ID<K, ?> var1, Project var2, GlobalSearchScope var3);

    public abstract void requestRebuild(ID<?, ?> var1, Throwable var2);

    public abstract <K> void scheduleRebuild(ID<K, ?> var1, Throwable var2);

    public abstract void requestReindex(VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(ID<K, V> var1, Set<K> var2, Processor<VirtualFile> var3, GlobalSearchScope var4);

    public abstract <K> boolean processAllKeys(ID<K, ?> var1, Processor<K> var2, Project var3);

    public <K> boolean processAllKeys(ID<K, ?> indexId, Processor<K> processor, GlobalSearchScope scope, IdFilter idFilter) {
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(Consumer<FileType> var1);
    }

    public static interface InputFilter {
        public boolean acceptInput(VirtualFile var1);
    }

    public static interface ValueProcessor<V> {
        public boolean process(VirtualFile var1, V var2);
    }
}

