/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class ReadOnlyAttributeUtil {
    public static void setReadOnlyAttribute(VirtualFile file, boolean readOnlyStatus) throws IOException {
        if (file.getFileSystem().isReadOnly()) {
            throw new IllegalArgumentException("Wrong file system: " + file.getFileSystem());
        }
        if (file.isWritable() == !readOnlyStatus) {
            return;
        }
        file.setWritable(!readOnlyStatus);
    }

    public static void setReadOnlyAttribute(String path, boolean readOnlyStatus) throws IOException {
        FileUtil.setReadOnlyAttribute((String)path, (boolean)readOnlyStatus);
    }
}

