/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.HostnameVerifier;

public final class RequestBuilder {
    private static final boolean ourWrapClassLoader = SystemInfo.isJavaVersionAtLeast((String)"1.7") && !SystemProperties.getBooleanProperty((String)"idea.parallel.class.loader", (boolean)true);
    final String myUrl;
    int myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
    int myTimeout = HttpConfigurable.READ_TIMEOUT;
    int myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
    boolean myGzip = true;
    boolean myForceHttps;
    HostnameVerifier myHostnameVerifier;
    String myUserAgent;
    String myAccept;
    HTTPMethod myMethod;

    RequestBuilder(String url) {
        this.myUrl = url;
    }

    public RequestBuilder connectTimeout(int value) {
        this.myConnectTimeout = value;
        return this;
    }

    public RequestBuilder readTimeout(int value) {
        this.myTimeout = value;
        return this;
    }

    public RequestBuilder redirectLimit(int redirectLimit) {
        this.myRedirectLimit = redirectLimit;
        return this;
    }

    public RequestBuilder gzip(boolean value) {
        this.myGzip = value;
        return this;
    }

    public RequestBuilder forceHttps(boolean forceHttps) {
        this.myForceHttps = forceHttps;
        return this;
    }

    public RequestBuilder hostNameVerifier(HostnameVerifier hostnameVerifier) {
        this.myHostnameVerifier = hostnameVerifier;
        return this;
    }

    public RequestBuilder userAgent(String userAgent) {
        this.myUserAgent = userAgent;
        return this;
    }

    public RequestBuilder productNameAsUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            return this.userAgent(ApplicationInfo.getInstance().getVersionName());
        }
        return this.userAgent("IntelliJ");
    }

    public RequestBuilder accept(String mimeType) {
        this.myAccept = mimeType;
        return this;
    }

    public <T> T connect(HttpRequests.RequestProcessor<T> processor) throws IOException {
        if (ourWrapClassLoader) {
            return HttpRequests.wrapAndProcess(this, processor);
        }
        return HttpRequests.process(this, processor);
    }

    public <T> T connect(HttpRequests.RequestProcessor<T> processor, T errorValue, Logger logger) {
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(final File file, final ProgressIndicator indicator) throws IOException {
        this.connect(new HttpRequests.RequestProcessor<Void>(){

            @Override
            public Void process(HttpRequests.Request request) throws IOException {
                request.saveToFile(file, indicator);
                return null;
            }
        });
    }

    public byte[] readBytes(final ProgressIndicator indicator) throws IOException {
        return this.connect(new HttpRequests.RequestProcessor<byte[]>(){

            @Override
            public byte[] process(HttpRequests.Request request) throws IOException {
                return request.readBytes(indicator);
            }
        });
    }

    public String readString(final ProgressIndicator indicator) throws IOException {
        return this.connect(new HttpRequests.RequestProcessor<String>(){

            @Override
            public String process(HttpRequests.Request request) throws IOException {
                int contentLength = request.getConnection().getContentLength();
                BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
                NetUtils.copyStreamContent(indicator, request.getInputStream(), (OutputStream)out, contentLength);
                return new String(out.getInternalBuffer(), 0, out.size(), HttpRequests.getCharset(request));
            }
        });
    }
}

