/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateTreeBuilder;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;

public class CertificateConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
CertificateListener {
    private static final FileTypeDescriptor CERTIFICATE_DESCRIPTOR = new FileTypeDescriptor("Choose Certificate", ".crt", ".cer", ".pem");
    @NonNls
    public static final String EMPTY_PANEL = "empty.panel";
    private JPanel myRootPanel;
    private JBCheckBox myAcceptAutomatically;
    private JBCheckBox myCheckHostname;
    private JBCheckBox myCheckValidityPeriod;
    private JPanel myCertificatesListPanel;
    private JPanel myDetailsPanel;
    private JPanel myEmptyPanel;
    private ConfirmingTrustManager.MutableTrustManager myTrustManager;
    private Tree myTree;
    private CertificateTreeBuilder myTreeBuilder;
    private Set<X509Certificate> myCertificates;

    public CertificateConfigurable() {
        this.$$$setupUI$$$();
        this.myCertificates = new HashSet();
    }

    private void initializeUI() {
        this.myTree = new Tree();
        this.myTreeBuilder = new CertificateTreeBuilder(this.myTree);
        this.myCheckHostname.setVisible(false);
        this.myCheckValidityPeriod.setVisible(false);
        this.myTrustManager = CertificateManager.getInstance().getCustomTrustManager();
        this.myTrustManager.addListener(this);
        this.myTree.getEmptyText().setText("No certificates");
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooser.chooseFile((FileChooserDescriptor)CERTIFICATE_DESCRIPTOR, null, null, new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file) {
                        String path = file.getPath();
                        X509Certificate certificate = CertificateUtil.loadX509Certificate(path);
                        if (certificate == null) {
                            Messages.showErrorDialog(CertificateConfigurable.this.myRootPanel, "Malformed X509 server certificate", "Not Imported");
                        } else if (CertificateConfigurable.this.myCertificates.contains(certificate)) {
                            Messages.showWarningDialog(CertificateConfigurable.this.myRootPanel, "Certificate already exists", "Not Imported");
                        } else {
                            CertificateConfigurable.this.myCertificates.add(certificate);
                            CertificateConfigurable.this.myTreeBuilder.addCertificate(certificate);
                            CertificateConfigurable.this.addCertificatePanel(certificate);
                            CertificateConfigurable.this.myTreeBuilder.selectCertificate(certificate);
                        }
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                for (X509Certificate certificate : CertificateConfigurable.this.myTreeBuilder.getSelectedCertificates(true)) {
                    CertificateConfigurable.this.myCertificates.remove(certificate);
                    CertificateConfigurable.this.myTreeBuilder.removeCertificate(certificate);
                }
                if (CertificateConfigurable.this.myCertificates.isEmpty()) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.EMPTY_PANEL);
                } else {
                    CertificateConfigurable.this.myTreeBuilder.selectFirstCertificate();
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                X509Certificate certificate = CertificateConfigurable.this.myTreeBuilder.getFirstSelectedCertificate(true);
                if (certificate != null) {
                    CertificateConfigurable.this.showCard(CertificateConfigurable.getCardName(certificate));
                }
            }
        });
        this.myCertificatesListPanel.add((Component)decorator.createPanel(), "Center");
    }

    private void showCard(String cardName) {
        ((CardLayout)this.myDetailsPanel.getLayout()).show(this.myDetailsPanel, cardName);
    }

    private void addCertificatePanel(X509Certificate certificate) {
        String uniqueName = CertificateConfigurable.getCardName(certificate);
        CertificateInfoPanel infoPanel = new CertificateInfoPanel(certificate);
        UIUtil.addInsets((JComponent)infoPanel, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        JBScrollPane scrollPane = new JBScrollPane(infoPanel);
        this.myDetailsPanel.add((Component)scrollPane, uniqueName);
    }

    private static String getCardName(X509Certificate certificate) {
        return certificate.getSubjectX500Principal().getName();
    }

    @Override
    public String getId() {
        return "http.certificates";
    }

    @Override
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Server Certificates";
    }

    @Override
    public String getHelpTopic() {
        return "reference.idesettings.server.certificates";
    }

    @Override
    public JComponent createComponent() {
        this.initializeUI();
        return this.myRootPanel;
    }

    @Override
    public boolean isModified() {
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        return this.myAcceptAutomatically.isSelected() != state.ACCEPT_AUTOMATICALLY || this.myCheckHostname.isSelected() != state.CHECK_HOSTNAME || this.myCheckValidityPeriod.isSelected() != state.CHECK_VALIDITY || !((Object)this.myCertificates).equals(new HashSet(this.myTrustManager.getCertificates()));
    }

    @Override
    public void apply() throws ConfigurationException {
        List<X509Certificate> existing = this.myTrustManager.getCertificates();
        HashSet added = new HashSet(this.myCertificates);
        added.removeAll(existing);
        HashSet removed = new HashSet(existing);
        removed.removeAll(this.myCertificates);
        for (X509Certificate certificate : added) {
            if (this.myTrustManager.addCertificate(certificate)) continue;
            throw new ConfigurationException("Cannot add certificate for " + CertificateUtil.getCommonName(certificate), "Cannot Add Certificate");
        }
        for (X509Certificate certificate : removed) {
            if (this.myTrustManager.removeCertificate(certificate)) continue;
            throw new ConfigurationException("Cannot remove certificate for " + CertificateUtil.getCommonName(certificate), "Cannot Remove Certificate");
        }
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        state.ACCEPT_AUTOMATICALLY = this.myAcceptAutomatically.isSelected();
        state.CHECK_HOSTNAME = this.myCheckHostname.isSelected();
        state.CHECK_VALIDITY = this.myCheckValidityPeriod.isSelected();
    }

    @Override
    public void reset() {
        List<X509Certificate> original = this.myTrustManager.getCertificates();
        this.myTreeBuilder.reset(original);
        this.myCertificates.clear();
        this.myCertificates.addAll(original);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)this.myEmptyPanel, EMPTY_PANEL);
        for (X509Certificate certificate : original) {
            this.addCertificatePanel(certificate);
        }
        if (!this.myCertificates.isEmpty()) {
            this.myTreeBuilder.selectFirstCertificate();
        }
        CertificateManager.Config state = CertificateManager.getInstance().getState();
        this.myAcceptAutomatically.setSelected(state.ACCEPT_AUTOMATICALLY);
        this.myCheckHostname.setSelected(state.CHECK_HOSTNAME);
        this.myCheckValidityPeriod.setSelected(state.CHECK_VALIDITY);
    }

    @Override
    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        this.myTrustManager.removeListener(this);
    }

    @Override
    public void certificateAdded(final X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CertificateConfigurable.this.myTreeBuilder != null && !CertificateConfigurable.this.myCertificates.contains(certificate)) {
                    CertificateConfigurable.this.myCertificates.add(certificate);
                    CertificateConfigurable.this.myTreeBuilder.addCertificate(certificate);
                    CertificateConfigurable.this.addCertificatePanel(certificate);
                }
            }
        });
    }

    @Override
    public void certificateRemoved(final X509Certificate certificate) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CertificateConfigurable.this.myTreeBuilder != null && CertificateConfigurable.this.myCertificates.contains(certificate)) {
                    CertificateConfigurable.this.myCertificates.remove(certificate);
                    CertificateConfigurable.this.myTreeBuilder.removeCertificate(certificate);
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCertificatesListPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(BorderFactory.createEtchedBorder(), "Accepted certificates", 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 1, null, null, null));
        this.myCheckHostname = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Check hostname");
        jBCheckBox3.setMnemonic('H');
        jBCheckBox3.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jBCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCheckValidityPeriod = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Check validity period");
        jBCheckBox2.setMnemonic('V');
        jBCheckBox2.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAcceptAutomatically = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Accept non-trusted certificates automatically");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(32);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDetailsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(499, 24), null));
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Card1");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("No certificate selected");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Splitter splitter = new Splitter();
        splitter.setShowDividerControls(false);
        splitter.setOrientation(true);
        splitter.setProportion(0.3f);
        jPanel4.add((Component)splitter, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setSecondComponent((JComponent)jPanel2);
        splitter.setFirstComponent((JComponent)jPanel3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

