/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import javax.swing.JComponent;

public abstract class LazyUiDisposable<T extends Disposable>
implements Activatable {
    private Throwable myAllocation;
    private boolean myWasEverShown;
    private final Disposable myParent;
    private final T myChild;

    public LazyUiDisposable(Disposable parent, JComponent ui, T child) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("idea.is.internal"))) {
            this.myAllocation = new Exception();
        }
        this.myParent = parent;
        this.myChild = child;
        new UiNotifyConnector.Once(ui, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void showNotify() {
        if (this.myWasEverShown) {
            return;
        }
        try {
            this.findParentDisposable().doWhenDone(new Consumer<Disposable>(){

                public void consume(Disposable parent) {
                    Project project = null;
                    if (ApplicationManager.getApplication() != null) {
                        project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
                    }
                    LazyUiDisposable.this.initialize(parent, LazyUiDisposable.this.myChild, project);
                    Disposer.register((Disposable)parent, (Disposable)LazyUiDisposable.this.myChild);
                }
            });
        }
        finally {
            this.myWasEverShown = true;
        }
    }

    @Override
    public final void hideNotify() {
    }

    protected abstract void initialize(Disposable var1, T var2, Project var3);

    private AsyncResult<Disposable> findParentDisposable() {
        return LazyUiDisposable.findDisposable(this.myParent, PlatformDataKeys.UI_DISPOSABLE);
    }

    private static AsyncResult<Disposable> findDisposable(Disposable defaultValue, final DataKey<? extends Disposable> key) {
        if (defaultValue == null) {
            if (ApplicationManager.getApplication() != null) {
                final AsyncResult<Disposable> result = new AsyncResult<Disposable>();
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(new Consumer<DataContext>(){

                    public void consume(DataContext context) {
                        Disposable disposable = (Disposable)key.getData(context);
                        if (disposable == null) {
                            disposable = Disposer.get((String)"ui");
                        }
                        result.setDone(disposable);
                    }
                });
                return result;
            }
            return null;
        }
        return new AsyncResult.Done<Disposable>(defaultValue);
    }
}

